/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.impl.Alias;
import com.codeborne.selenide.impl.CollectionSource;
import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.WebElement;

public class FilteringCollection
implements CollectionSource {
    private final CollectionSource originalCollection;
    private final WebElementCondition filter;
    private Alias alias = Alias.NONE;

    public FilteringCollection(CollectionSource originalCollection, WebElementCondition filter) {
        this.originalCollection = originalCollection;
        this.filter = filter;
    }

    @Override
    public List<WebElement> getElements() {
        return this.originalCollection.getElements().stream().filter(webElement -> this.filter.check(this.originalCollection.driver(), (WebElement)webElement).verdict() == CheckResult.Verdict.ACCEPT).collect(Collectors.toList());
    }

    @Override
    public WebElement getElement(int index) {
        return this.originalCollection.getElements().stream().filter(webElement -> this.filter.check(this.originalCollection.driver(), (WebElement)webElement).verdict() == CheckResult.Verdict.ACCEPT).skip(index).findFirst().orElseThrow(() -> new IndexOutOfBoundsException("Index: " + index));
    }

    @Override
    public String getSearchCriteria() {
        return this.originalCollection.description() + ".filter(" + this.filter + ")";
    }

    public String toString() {
        return this.originalCollection + ".filter(" + this.filter + ")";
    }

    @Override
    public Driver driver() {
        return this.originalCollection.driver();
    }

    @Override
    public Alias getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(String alias) {
        this.alias = new Alias(alias);
    }
}

