/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.impl.CollectionSource;
import com.codeborne.selenide.impl.SelenideElementProxy;
import com.codeborne.selenide.impl.WebElementSource;
import java.lang.reflect.Proxy;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.WebElement;

public class LastCollectionElement
extends WebElementSource {
    private final CollectionSource collection;

    public static SelenideElement wrap(CollectionSource collection) {
        return (SelenideElement)Proxy.newProxyInstance(collection.getClass().getClassLoader(), new Class[]{SelenideElement.class}, new SelenideElementProxy(new LastCollectionElement(collection)));
    }

    LastCollectionElement(CollectionSource collection) {
        this.collection = collection;
    }

    @Override
    public Driver driver() {
        return this.collection.driver();
    }

    @Override
    public WebElement getWebElement() {
        return this.lastElementOf(this.collection.getElements());
    }

    private <T> T lastElementOf(List<T> collection) {
        return collection.get(collection.size() - 1);
    }

    @Override
    public String getSearchCriteria() {
        return this.collection.getSearchCriteria() + ":last";
    }

    @Override
    public String description() {
        return this.getAlias().getOrElse(() -> this.collection.shortDescription() + ":last");
    }

    @Override
    public ElementNotFound createElementNotFoundError(WebElementCondition condition, @Nullable Throwable cause) {
        if (this.collection.getElements().isEmpty()) {
            return new ElementNotFound(this.getAlias(), this.getSearchCriteria(), Condition.visible, cause);
        }
        return super.createElementNotFoundError(condition, cause);
    }
}

