/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl.windows;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.support.ui.ExpectedCondition;

public class FrameByIdOrName
implements ExpectedCondition<WebDriver> {
    private final By locator;

    public FrameByIdOrName(String frame) {
        this.locator = By.cssSelector((String)String.format("frame#%1$s,frame[name=%1$s],iframe#%1$s,iframe[name=%1$s]", frame));
    }

    public @Nullable WebDriver apply(WebDriver driver) {
        try {
            return Objects.requireNonNull(driver).switchTo().frame(driver.findElement(this.locator));
        }
        catch (WebDriverException e) {
            return null;
        }
    }

    public String toString() {
        return "frame to be available: " + this.locator;
    }
}

