/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.WebDriverProvider;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.impl.Describe;
import java.awt.Toolkit;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.internal.BuildInfo;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.LocalFileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;

public class WebDriverFactory {
    private static final Logger log = Logger.getLogger(WebDriverFactory.class.getName());

    public WebDriver createWebDriver(Proxy proxy) {
        log.config("Configuration.browser=" + Configuration.browser);
        log.config("Configuration.browser.version=" + Configuration.browserVersion);
        log.config("Configuration.remote=" + Configuration.remote);
        log.config("Configuration.browserSize=" + Configuration.browserSize);
        log.config("Configuration.startMaximized=" + Configuration.startMaximized);
        WebDriver webdriver = Configuration.remote != null ? this.createRemoteDriver(Configuration.remote, Configuration.browser, proxy) : ("chrome".equalsIgnoreCase(Configuration.browser) ? this.createChromeDriver(proxy) : (WebDriverRunner.isMarionette() ? this.createMarionetteDriver(proxy) : (WebDriverRunner.isFirefox() ? this.createFirefoxDriver(proxy) : (WebDriverRunner.isHtmlUnit() ? this.createHtmlUnitDriver(proxy) : (WebDriverRunner.isEdge() ? this.createEdgeDriver(proxy) : (WebDriverRunner.isIE() ? this.createInternetExplorerDriver(proxy) : (WebDriverRunner.isPhantomjs() ? this.createPhantomJsDriver(proxy) : (WebDriverRunner.isOpera() ? this.createOperaDriver(proxy) : (WebDriverRunner.isSafari() ? this.createSafariDriver(proxy) : (WebDriverRunner.isJBrowser() ? this.createJBrowserDriver(proxy) : this.createInstanceOf(Configuration.browser, proxy)))))))))));
        webdriver = this.adjustBrowserSize(webdriver);
        if (!WebDriverRunner.isHeadless()) {
            Capabilities capabilities = ((RemoteWebDriver)webdriver).getCapabilities();
            log.info("BrowserName=" + capabilities.getBrowserName() + " Version=" + capabilities.getVersion() + " Platform=" + capabilities.getPlatform());
        }
        log.info("Selenide v. " + Selenide.class.getPackage().getImplementationVersion());
        if (Configuration.remote == null) {
            BuildInfo seleniumInfo = new BuildInfo();
            log.info("Selenium WebDriver v. " + seleniumInfo.getReleaseLabel() + " build time: " + seleniumInfo.getBuildTime());
        } else {
            ((RemoteWebDriver)webdriver).setFileDetector((FileDetector)new LocalFileDetector());
        }
        return webdriver;
    }

    protected WebDriver createRemoteDriver(String remote, String browser, Proxy proxy) {
        try {
            DesiredCapabilities capabilities = this.createCommonCapabilities(proxy);
            capabilities.setBrowserName(browser);
            return new RemoteWebDriver(new URL(remote), (Capabilities)capabilities);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid 'remote' parameter: " + remote, e);
        }
    }

    protected DesiredCapabilities createCommonCapabilities(Proxy proxy) {
        DesiredCapabilities browserCapabilities = new DesiredCapabilities();
        if (proxy != null) {
            browserCapabilities.setCapability("proxy", (Object)proxy);
        }
        if (Configuration.browserVersion != null && !Configuration.browserVersion.isEmpty()) {
            browserCapabilities.setVersion(Configuration.browserVersion);
        }
        browserCapabilities.setCapability("pageLoadStrategy", Configuration.pageLoadStrategy);
        browserCapabilities.setCapability("acceptSslCerts", true);
        browserCapabilities = this.transferCapabilitiesFromSystemProperties(browserCapabilities, "capabilities.");
        return browserCapabilities;
    }

    private DesiredCapabilities transferCapabilitiesFromSystemProperties(DesiredCapabilities currentBrowserCapabilities, String prefix) {
        for (String key : System.getProperties().stringPropertyNames()) {
            if (!key.startsWith(prefix)) continue;
            String capability = key.substring(prefix.length());
            String value = System.getProperties().getProperty(key);
            log.config("Use " + key + "=" + value);
            if (value.equals("true") || value.equals("false")) {
                currentBrowserCapabilities.setCapability(capability, (Object)Boolean.valueOf(value));
                continue;
            }
            if (value.matches("^-?\\d+$")) {
                currentBrowserCapabilities.setCapability(capability, (Object)Integer.parseInt(value));
                continue;
            }
            currentBrowserCapabilities.setCapability(capability, value);
        }
        return currentBrowserCapabilities;
    }

    private FirefoxProfile transferFirefoxProfileFromSystemProperties(FirefoxProfile currentFirefoxProfile, String prefix) {
        for (String key : System.getProperties().stringPropertyNames()) {
            if (!key.startsWith(prefix)) continue;
            String capability = key.substring(prefix.length());
            String value = System.getProperties().getProperty(key);
            log.config("Use " + key + "=" + value);
            if (value.equals("true") || value.equals("false")) {
                currentFirefoxProfile.setPreference(capability, Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (value.matches("^-?\\d+$")) {
                currentFirefoxProfile.setPreference(capability, Integer.parseInt(value));
                continue;
            }
            currentFirefoxProfile.setPreference(capability, value);
        }
        return currentFirefoxProfile;
    }

    private ChromeOptions transferChromeOptionsFromSystemProperties(ChromeOptions currentChromeOptions, String prefix) {
        for (String key : System.getProperties().stringPropertyNames()) {
            if (!key.startsWith(prefix)) continue;
            String capability = key.substring(prefix.length());
            String value = System.getProperties().getProperty(key);
            if (capability.equals("args")) {
                List<String> args = Arrays.asList(value.split(","));
                currentChromeOptions.addArguments(args);
                continue;
            }
            log.warning(capability + "is ignored." + "Only so-called arguments (chromeoptions.args=<values comma separated>) " + "are supported for the chromeoptions at the moment");
        }
        return currentChromeOptions;
    }

    protected WebDriver createChromeDriver(Proxy proxy) {
        DesiredCapabilities capabilities = this.createCommonCapabilities(proxy);
        ChromeOptions options = this.createChromeOptions();
        capabilities.setCapability("chromeOptions", (Object)options);
        return new ChromeDriver((Capabilities)capabilities);
    }

    protected ChromeOptions createChromeOptions() {
        ChromeOptions options = new ChromeOptions();
        options.addArguments(new String[]{"--no-sandbox"});
        if (Configuration.chromeSwitches != null) {
            options.addArguments(new String[]{Configuration.chromeSwitches});
        }
        options = this.transferChromeOptionsFromSystemProperties(options, "chromeoptions.");
        try {
            log.config("Chrome options:" + options.toJson().toString());
        }
        catch (IOException e) {
            log.warning("Error while reading from file:" + e.getMessage() + ". Ignoring it.");
            e.printStackTrace(System.err);
        }
        return options;
    }

    protected WebDriver createFirefoxDriver(Proxy proxy) {
        DesiredCapabilities capabilities = this.createFirefoxCapabilities(proxy);
        log.info("Firefox 48+ is currently not supported by Selenium Firefox driver. Use browser=marionette with geckodriver, when using it.");
        return new FirefoxDriver((Capabilities)capabilities);
    }

    protected DesiredCapabilities createFirefoxCapabilities(Proxy proxy) {
        FirefoxProfile myProfile = new FirefoxProfile();
        myProfile.setPreference("network.automatic-ntlm-auth.trusted-uris", "http://,https://");
        myProfile.setPreference("network.automatic-ntlm-auth.allow-non-fqdn", true);
        myProfile.setPreference("network.negotiate-auth.delegation-uris", "http://,https://");
        myProfile.setPreference("network.negotiate-auth.trusted-uris", "http://,https://");
        myProfile.setPreference("network.http.phishy-userpass-length", 255);
        myProfile.setPreference("security.csp.enable", false);
        DesiredCapabilities capabilities = this.createCommonCapabilities(proxy);
        myProfile = this.transferFirefoxProfileFromSystemProperties(myProfile, "firefoxprofile.");
        capabilities.setCapability("firefox_profile", (Object)myProfile);
        capabilities.setCapability("marionette", false);
        return capabilities;
    }

    protected WebDriver createMarionetteDriver(Proxy proxy) {
        DesiredCapabilities capabilities = this.createFirefoxCapabilities(proxy);
        capabilities.setCapability("marionette", true);
        return new FirefoxDriver((Capabilities)capabilities);
    }

    protected WebDriver createHtmlUnitDriver(Proxy proxy) {
        DesiredCapabilities capabilities = DesiredCapabilities.htmlUnitWithJs();
        capabilities.merge((Capabilities)this.createCommonCapabilities(proxy));
        capabilities.setCapability("The xpath expression '%s' selected an object of type '%s' instead of a WebElement", true);
        capabilities.setCapability("The xpath expression '%s' cannot be evaluated", false);
        if (Configuration.browser.indexOf(58) > -1) {
            String emulatedBrowser = Configuration.browser.replaceFirst("htmlunit:(.*)", "$1");
            capabilities.setVersion(emulatedBrowser);
        }
        return new HtmlUnitDriver((Capabilities)capabilities);
    }

    protected WebDriver createInternetExplorerDriver(Proxy proxy) {
        DesiredCapabilities capabilities = this.createCommonCapabilities(proxy);
        return new InternetExplorerDriver((Capabilities)capabilities);
    }

    protected WebDriver createEdgeDriver(Proxy proxy) {
        DesiredCapabilities capabilities = this.createCommonCapabilities(proxy);
        return new EdgeDriver((Capabilities)capabilities);
    }

    protected WebDriver createPhantomJsDriver(Proxy proxy) {
        return this.createInstanceOf("org.openqa.selenium.phantomjs.PhantomJSDriver", proxy);
    }

    protected WebDriver createOperaDriver(Proxy proxy) {
        return this.createInstanceOf("com.opera.core.systems.OperaDriver", proxy);
    }

    protected WebDriver createSafariDriver(Proxy proxy) {
        return this.createInstanceOf("org.openqa.selenium.safari.SafariDriver", proxy);
    }

    protected WebDriver createJBrowserDriver(Proxy proxy) {
        return this.createInstanceOf("com.machinepublishers.jbrowserdriver.JBrowserDriver", proxy);
    }

    protected WebDriver adjustBrowserSize(WebDriver driver) {
        if (Configuration.browserSize != null) {
            log.info("Set browser size to " + Configuration.browserSize);
            String[] dimension = Configuration.browserSize.split("x");
            int width = Integer.parseInt(dimension[0]);
            int height = Integer.parseInt(dimension[1]);
            driver.manage().window().setSize(new Dimension(width, height));
        } else if (Configuration.startMaximized) {
            try {
                if (WebDriverRunner.isChrome()) {
                    this.maximizeChromeBrowser(driver.manage().window());
                } else {
                    driver.manage().window().maximize();
                }
            }
            catch (Exception cannotMaximize) {
                log.warning("Cannot maximize " + Describe.describe(driver) + ": " + cannotMaximize);
            }
        }
        return driver;
    }

    protected void maximizeChromeBrowser(WebDriver.Window window) {
        Dimension screenResolution = this.getScreenSize();
        window.setSize(screenResolution);
        window.setPosition(new Point(0, 0));
    }

    Dimension getScreenSize() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        return new Dimension((int)toolkit.getScreenSize().getWidth(), (int)toolkit.getScreenSize().getHeight());
    }

    protected WebDriver createInstanceOf(String className, Proxy proxy) {
        try {
            Class<?> clazz;
            DesiredCapabilities capabilities = this.createCommonCapabilities(proxy);
            capabilities.setJavascriptEnabled(true);
            capabilities.setCapability("takesScreenshot", true);
            capabilities.setCapability("acceptSslCerts", true);
            capabilities.setCapability("handlesAlerts", true);
            if (WebDriverRunner.isPhantomjs()) {
                capabilities.setCapability("phantomjs.cli.args", (Object)new String[]{"--web-security=no", "--ignore-ssl-errors=yes"});
            }
            if (WebDriverProvider.class.isAssignableFrom(clazz = Class.forName(className))) {
                Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return ((WebDriverProvider)constructor.newInstance(new Object[0])).createDriver(capabilities);
            }
            Constructor<?> constructor = Class.forName(className).getConstructor(Capabilities.class);
            return (WebDriver)constructor.newInstance(capabilities);
        }
        catch (InvocationTargetException e) {
            throw this.runtime(e.getTargetException());
        }
        catch (Exception invalidClassName) {
            throw new IllegalArgumentException(invalidClassName);
        }
    }

    protected RuntimeException runtime(Throwable exception) {
        return exception instanceof RuntimeException ? (RuntimeException)exception : new RuntimeException(exception);
    }
}

