/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import java.util.List;
import org.openqa.selenium.WebElement;

public class Or
extends Condition {
    private final List<Condition> conditions;
    private Condition firstFailedCondition;

    public Or(String name, List<Condition> conditions) {
        super(name);
        this.conditions = conditions;
    }

    @Override
    public boolean apply(Driver driver, WebElement element) {
        this.firstFailedCondition = null;
        for (Condition c : this.conditions) {
            if (c.apply(driver, element)) {
                return true;
            }
            if (this.firstFailedCondition != null) continue;
            this.firstFailedCondition = c;
        }
        return false;
    }

    @Override
    public String actualValue(Driver driver, WebElement element) {
        return this.firstFailedCondition == null ? null : this.firstFailedCondition.actualValue(driver, element);
    }

    @Override
    public String toString() {
        return this.firstFailedCondition == null ? super.toString() : this.firstFailedCondition.toString();
    }
}

