/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.impl.Html;
import org.openqa.selenium.WebElement;

public class Value
extends Condition {
    private final String expectedValue;

    public Value(String expectedValue) {
        super("value");
        this.expectedValue = expectedValue;
    }

    @Override
    public boolean apply(Driver driver, WebElement element) {
        return Html.text.contains(this.getValueAttribute(element), this.expectedValue);
    }

    @Override
    public String toString() {
        return this.getName() + " '" + this.expectedValue + "'";
    }

    private String getValueAttribute(WebElement element) {
        String attr = element.getAttribute("value");
        return attr == null ? "" : attr;
    }
}

