/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.drivercommands;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.UnreachableBrowserException;

public class BrowserHealthChecker {
    private static final Logger log = Logger.getLogger(BrowserHealthChecker.class.getName());

    public boolean isBrowserStillOpen(WebDriver webDriver) {
        try {
            webDriver.getTitle();
            return true;
        }
        catch (UnreachableBrowserException e) {
            log.log(Level.FINE, "Browser is unreachable", e);
            return false;
        }
        catch (NoSuchWindowException e) {
            log.log(Level.FINE, "Browser window is not found", e);
            return false;
        }
        catch (NoSuchSessionException e) {
            log.log(Level.FINE, "Browser session is not found", e);
            return false;
        }
    }
}

