/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.drivercommands;

import com.codeborne.selenide.drivercommands.CloseBrowser;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.WebDriver;

public class CloseDriverCommand {
    private static final Logger log = Logger.getLogger(CloseDriverCommand.class.getName());
    private final WebDriver webDriver;
    private final SelenideProxyServer selenideProxyServer;

    CloseDriverCommand(WebDriver webDriver, SelenideProxyServer selenideProxyServer) {
        this.webDriver = webDriver;
        this.selenideProxyServer = selenideProxyServer;
    }

    public void run() {
        long threadId = Thread.currentThread().getId();
        if (this.webDriver != null) {
            log.info("Close webdriver: " + threadId + " -> " + this.webDriver);
            if (this.selenideProxyServer != null) {
                log.info("Close proxy server: " + threadId + " -> " + this.selenideProxyServer);
            }
            long start = System.currentTimeMillis();
            Thread t = new Thread(new CloseBrowser(this.webDriver, this.selenideProxyServer));
            t.setDaemon(true);
            t.start();
            try {
                t.join();
            }
            catch (InterruptedException e) {
                long duration = System.currentTimeMillis() - start;
                log.log(Level.FINE, "Failed to close webdriver " + threadId + " in " + duration + " ms", e);
                Thread.currentThread().interrupt();
            }
            long duration = System.currentTimeMillis() - start;
            log.info("Closed webdriver " + threadId + " in " + duration + " ms");
        } else if (this.selenideProxyServer != null) {
            log.info("Close proxy server: " + threadId + " -> " + this.selenideProxyServer);
            this.selenideProxyServer.shutdown();
        }
    }
}

