/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.drivercommands;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.drivercommands.BrowserHealthChecker;
import com.codeborne.selenide.drivercommands.CloseDriverCommand;
import com.codeborne.selenide.drivercommands.CreateDriverCommand;
import com.codeborne.selenide.drivercommands.SelenideDriverFinalCleanupThread;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import com.codeborne.selenide.webdriver.WebDriverFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.events.WebDriverEventListener;

public class LazyDriver
implements Driver {
    private static final Logger log = Logger.getLogger(LazyDriver.class.getName());
    private final Config config;
    private final BrowserHealthChecker browserHealthChecker;
    private final WebDriverFactory factory;
    private final Proxy userProvidedProxy;
    private final List<WebDriverEventListener> listeners = new ArrayList<WebDriverEventListener>();
    private final Browser browser;
    private boolean closed;
    private WebDriver webDriver;
    private SelenideProxyServer selenideProxyServer;

    public LazyDriver(Config config, Proxy userProvidedProxy, List<WebDriverEventListener> listeners) {
        this(config, userProvidedProxy, listeners, new WebDriverFactory(), new BrowserHealthChecker());
    }

    LazyDriver(Config config, Proxy userProvidedProxy, List<WebDriverEventListener> listeners, WebDriverFactory factory, BrowserHealthChecker browserHealthChecker) {
        this.config = config;
        this.browser = new Browser(config.browser(), config.headless());
        this.userProvidedProxy = userProvidedProxy;
        this.listeners.addAll(listeners);
        this.factory = factory;
        this.browserHealthChecker = browserHealthChecker;
    }

    @Override
    public Config config() {
        return this.config;
    }

    @Override
    public Browser browser() {
        return this.browser;
    }

    @Override
    public boolean hasWebDriverStarted() {
        return this.webDriver != null;
    }

    @Override
    public synchronized WebDriver getWebDriver() {
        if (this.closed) {
            throw new IllegalStateException("Webdriver has been closed. You need to call open(url) to open a browser again.");
        }
        if (this.webDriver == null) {
            throw new IllegalStateException("No webdriver is bound to current thread: " + Thread.currentThread().getId() + ". You need to call open(url) first.");
        }
        return this.webDriver;
    }

    @Override
    public SelenideProxyServer getProxy() {
        return this.selenideProxyServer;
    }

    @Override
    public synchronized WebDriver getAndCheckWebDriver() {
        if (this.webDriver != null && this.config.reopenBrowserOnFail() && !this.browserHealthChecker.isBrowserStillOpen(this.webDriver)) {
            log.info("Webdriver has been closed meanwhile. Let's re-create it.");
            this.close();
            this.createDriver();
        } else if (this.webDriver == null) {
            log.info("No webdriver is bound to current thread: " + Thread.currentThread().getId() + " - let's create a new webdriver");
            this.createDriver();
        }
        return this.getWebDriver();
    }

    void createDriver() {
        CreateDriverCommand.Result result = new CreateDriverCommand().createDriver(this.config, this.factory, this.userProvidedProxy, this.listeners);
        this.webDriver = result.webDriver;
        this.selenideProxyServer = result.selenideProxyServer;
        this.closed = false;
        Runtime.getRuntime().addShutdownHook(new SelenideDriverFinalCleanupThread(this));
    }

    @Override
    public void close() {
        if (!this.config.holdBrowserOpen()) {
            new CloseDriverCommand(this.webDriver, this.selenideProxyServer).run();
            this.webDriver = null;
            this.selenideProxyServer = null;
            this.closed = true;
        }
    }
}

