/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.impl.Cleanup;
import java.util.Arrays;
import java.util.logging.Logger;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebElement;

public class Events {
    public static Events events = new Events();
    Logger log = Logger.getLogger(Events.class.getName());
    private final String jsCodeToTriggerEvent = "var webElement = arguments[0];\nvar eventNames = arguments[1];\nfor (var i = 0; i < eventNames.length; i++) {  if (document.createEventObject) {\n    var evt = document.createEventObject();\n    webElement.fireEvent('on' + eventNames[i], evt);\n  }\n  else {\n    var evt = document.createEvent('HTMLEvents');\n     evt.initEvent(eventNames[i], true, true );\n     webElement.dispatchEvent(evt);\n  }\n}";

    public void fireEvent(Driver driver, WebElement element, String ... event) {
        try {
            this.executeJavaScript(driver, element, event);
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
        }
        catch (Exception e) {
            this.log.warning("Failed to trigger events " + Arrays.asList(event) + ": " + Cleanup.of.webdriverExceptionMessage(e));
        }
    }

    void executeJavaScript(Driver driver, WebElement element, String ... event) {
        driver.executeJavaScript("var webElement = arguments[0];\nvar eventNames = arguments[1];\nfor (var i = 0; i < eventNames.length; i++) {  if (document.createEventObject) {\n    var evt = document.createEventObject();\n    webElement.fireEvent('on' + eventNames[i], evt);\n  }\n  else {\n    var evt = document.createEvent('HTMLEvents');\n     evt.initEvent(eventNames[i], true, true );\n     webElement.dispatchEvent(evt);\n  }\n}", element, event);
    }
}

