/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.SelenideDriver;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;

class UnusedWebdriversCleanupThread
extends Thread {
    private static final Logger log = Logger.getLogger(UnusedWebdriversCleanupThread.class.getName());
    private final Collection<Thread> allWebDriverThreads;
    private final Map<Long, SelenideDriver> threadWebDriver;

    UnusedWebdriversCleanupThread(Collection<Thread> allWebDriverThreads, Map<Long, SelenideDriver> threadWebDriver) {
        this.allWebDriverThreads = allWebDriverThreads;
        this.threadWebDriver = threadWebDriver;
        this.setDaemon(true);
        this.setName("Webdrivers killer thread");
    }

    @Override
    public void run() {
        while (true) {
            this.closeUnusedWebdrivers();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    private void closeUnusedWebdrivers() {
        for (Thread thread : this.allWebDriverThreads) {
            if (thread.isAlive()) continue;
            log.info("Thread " + thread.getId() + " is dead. Let's close webdriver " + this.threadWebDriver.get(thread.getId()));
            this.closeWebDriver(thread);
        }
    }

    private void closeWebDriver(Thread thread) {
        this.allWebDriverThreads.remove(thread);
        SelenideDriver selenideDriver = this.threadWebDriver.remove(thread.getId());
        if (selenideDriver == null) {
            log.info("No webdriver found for thread : " + thread.getId() + " - nothing to close");
        } else {
            selenideDriver.close();
        }
    }
}

