/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.webdriver.AbstractDriverFactory;
import java.util.logging.Logger;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;

class SafariDriverFactory
extends AbstractDriverFactory {
    private static final Logger log = Logger.getLogger(SafariDriverFactory.class.getName());

    SafariDriverFactory() {
    }

    @Override
    boolean supports(Config config, Browser browser) {
        return browser.isSafari();
    }

    @Override
    WebDriver create(Config config, Proxy proxy) {
        return this.createSafariDriver(config, proxy);
    }

    private WebDriver createSafariDriver(Config config, Proxy proxy) {
        if (!config.browserBinary().isEmpty()) {
            log.info("Using browser binary: " + config.browserBinary());
            log.warning("Changing browser binary not supported in Safari, setting will be ignored.");
        }
        return this.createInstanceOf("org.openqa.selenium.safari.SafariDriver", config, proxy);
    }
}

