/*
 * Decompiled with CFR 0.152.
 */
package com.codepine.api.testrail.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;

public class StringToMapDeserializer
extends JsonDeserializer<Map<String, String>> {
    public Map<String, String> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (jp.getValueAsString() == null) {
            return null;
        }
        Map items = Splitter.on((String)"\n").omitEmptyStrings().withKeyValueSeparator(',').split((CharSequence)jp.getValueAsString());
        items = Maps.transformValues((Map)items, (Function)new Function<String, String>(){

            public String apply(String value) {
                return value.trim();
            }
        });
        return items;
    }
}

