/*
 * Decompiled with CFR 0.152.
 */
package com.comcast.viper.hlsparserj.tags;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UnparsedTag {
    private static final Pattern TAGPATTERN = Pattern.compile("^#(EXT.*?):(.*)");
    private static final String NONENCLOSEDQUOTES = ",(?=([^\"]*\"[^\"]*\")*[^\"]*$)";
    private static final String URI_ATTR = "URI";
    private String tagName;
    private Map<String, String> attributes;
    private String uri;
    private String rawTag;

    public UnparsedTag() {
        this.attributes = new HashMap<String, String>();
    }

    public UnparsedTag(String line) {
        this.rawTag = line;
        this.attributes = new HashMap<String, String>();
        this.parseTagLine(line);
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public String getURI() {
        return this.uri;
    }

    public void setURI(String uriString) {
        this.uri = uriString;
    }

    public String getRawTag() {
        return this.rawTag;
    }

    private void parseTagLine(String line) {
        Matcher lineMatcher = TAGPATTERN.matcher(line);
        if (lineMatcher.find()) {
            this.tagName = lineMatcher.group(1);
            String attributeList = lineMatcher.group(2);
            int noNameCount = 0;
            for (String attribute : attributeList.split(NONENCLOSEDQUOTES)) {
                String[] nameValuePair = attribute.split("=");
                if (nameValuePair.length == 1) {
                    this.attributes.put("NONAME" + noNameCount, nameValuePair[0].replaceAll("^\"|\"$", ""));
                } else {
                    this.attributes.put(nameValuePair[0].trim(), nameValuePair[1].replaceAll("^\"|\"$", ""));
                }
                ++noNameCount;
            }
            if (this.attributes.containsKey(URI_ATTR)) {
                this.uri = this.attributes.get(URI_ATTR);
            }
        } else {
            this.tagName = line.substring(1);
        }
    }
}

