/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.code.format.executable;

import com.cosium.code.format.MavenGitCodeFormatException;
import com.cosium.code.format.executable.Executable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;

class DefaulExecutable
implements Executable {
    private static final String SHIBANG = "#!/bin/bash";
    private final Supplier<Log> log;
    private final Path file;

    DefaulExecutable(Supplier<Log> log, Path file) throws IOException {
        Set<PosixFilePermission> permissions;
        Objects.requireNonNull(log);
        Objects.requireNonNull(file);
        this.log = log;
        this.file = file;
        if (!Files.exists(file, new LinkOption[0])) {
            this.log.get().debug((CharSequence)("Creating " + file));
            Files.createFile(file, new FileAttribute[0]);
            this.truncate();
        } else {
            this.log.get().debug((CharSequence)(file + " already exists"));
        }
        this.log.get().debug((CharSequence)("Marking '" + file + "' as executable"));
        try {
            permissions = Files.getPosixFilePermissions(file, new LinkOption[0]);
        }
        catch (UnsupportedOperationException ignored) {
            return;
        }
        permissions.add(PosixFilePermission.OWNER_EXECUTE);
        permissions.add(PosixFilePermission.GROUP_EXECUTE);
        permissions.add(PosixFilePermission.OTHERS_EXECUTE);
        Files.setPosixFilePermissions(file, permissions);
    }

    @Override
    public Executable truncate() throws IOException {
        this.log.get().debug((CharSequence)("Truncating '" + this.file + "'"));
        Files.write(this.file, Collections.singleton(SHIBANG), StandardOpenOption.TRUNCATE_EXISTING);
        return this;
    }

    @Override
    public Executable truncateWithTemplate(Supplier<InputStream> template, String sourceEncoding, Object ... values) throws IOException {
        try (InputStream inputStream = template.get();){
            String rawContent = IOUtils.toString((InputStream)inputStream, (String)sourceEncoding);
            Object[] refinedValues = Stream.of(values).map(this::unixifyPath).toArray();
            String content = String.format(rawContent, refinedValues);
            Files.write(this.file, content.getBytes(), StandardOpenOption.TRUNCATE_EXISTING);
        }
        return this;
    }

    @Override
    public Executable appendCommandCall(String commandCall) throws IOException {
        String unixCommandCall = this.unixifyPath(commandCall, true);
        boolean callExists = Files.readAllLines(this.file).stream().anyMatch(s -> s.contains(unixCommandCall));
        if (callExists) {
            this.log.get().debug((CharSequence)("Command call already exists in " + this.file));
        } else {
            this.log.get().debug((CharSequence)("No command call found in " + this.file));
            this.log.get().debug((CharSequence)("Appending the command call to " + this.file));
            Files.write(this.file, Collections.singletonList(unixCommandCall), StandardOpenOption.APPEND);
            this.log.get().debug((CharSequence)("Appended the command call to " + this.file));
        }
        return this;
    }

    @Override
    public Executable removeCommandCall(String commandCall) {
        String unixCommandCall = this.unixifyPath(commandCall, true);
        try {
            List linesToKeep = Files.readAllLines(this.file).stream().filter(line -> !unixCommandCall.equals(line)).collect(Collectors.toList());
            Files.write(this.file, linesToKeep, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new MavenGitCodeFormatException(e);
        }
        return this;
    }

    private String unixifyPath(Object o) {
        return this.unixifyPath(o, false);
    }

    private String unixifyPath(Object o, boolean force) {
        String result;
        if (!force && !(o instanceof Path)) {
            return String.valueOf(o);
        }
        if (o instanceof Path) {
            Path path = (Path)o;
            result = path.toAbsolutePath().toString();
        } else {
            result = String.valueOf(o);
        }
        return "\"" + StringUtils.replace((String)result, (String)"\\", (String)"/") + "\"";
    }

    public String toString() {
        return this.file.toString();
    }
}

