/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.code.format.git;

import com.cosium.code.format.MavenGitCodeFormatException;
import com.cosium.code.format.TemporaryFile;
import com.cosium.code.format.formatter.CodeFormatters;
import com.cosium.code.format.git.AutoCRLFRepository;
import com.cosium.code.format.git.GitIndexEntry;
import com.cosium.code.format.git.Index;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;

public class GitStagedFiles {
    private final Log log;
    private final Repository repository;
    private final Set<String> filePaths;
    private final CoreConfig.EolStreamType eolStreamType;

    private GitStagedFiles(Log log, Repository repository, Set<String> filePaths) {
        this.log = Objects.requireNonNull(log);
        this.repository = Objects.requireNonNull(repository);
        this.filePaths = Collections.unmodifiableSet(filePaths);
        WorkingTreeOptions workingTreeOptions = (WorkingTreeOptions)repository.getConfig().get(WorkingTreeOptions.KEY);
        this.eolStreamType = workingTreeOptions.getAutoCRLF() == CoreConfig.AutoCRLF.TRUE ? CoreConfig.EolStreamType.AUTO_CRLF : CoreConfig.EolStreamType.DIRECT;
        log.debug((CharSequence)("eolStreamType is '" + this.eolStreamType + "'"));
    }

    public static GitStagedFiles read(Log log, Repository repository, Predicate<Path> fileFilter) throws GitAPIException {
        Status gitStatus = new Git(repository).status().call();
        Path workTree = repository.getWorkTree().toPath();
        Set<String> filePaths = Stream.concat(gitStatus.getChanged().stream(), gitStatus.getAdded().stream()).filter(relativePath -> fileFilter.test(workTree.resolve((String)relativePath))).collect(Collectors.toSet());
        log.debug((CharSequence)("Staged files: " + filePaths));
        return new GitStagedFiles(log, repository, filePaths);
    }

    public void format(CodeFormatters formatters) throws IOException {
        if (this.filePaths.isEmpty()) {
            this.log.debug((CharSequence)"No staged files to format");
            return;
        }
        Git git = new Git(this.repository);
        try (Index index = Index.lock(this.repository);
             TemporaryFile temporaryDiffFile = TemporaryFile.create(this.log, "diff-between-unformatted-and-formatted-files");){
            DirCacheEditor dirCacheEditor = index.editor();
            this.filePaths.stream().map(path -> new GitIndexEntry(this.log, this.repository, (String)path)).map(indexEntry -> indexEntry.entryFormatter(formatters)).forEach(arg_0 -> ((DirCacheEditor)dirCacheEditor).add(arg_0));
            dirCacheEditor.finish();
            index.write();
            try (AutoCRLFRepository autoCRLFRepository = new AutoCRLFRepository(git.getRepository().getDirectory(), this.eolStreamType);
                 OutputStream diffOutput = temporaryDiffFile.newOutputStream();){
                new Git((Repository)autoCRLFRepository).diff().setOutputStream(diffOutput).setOldTree(this.treeIterator(this.repository.readDirCache())).setNewTree(index.treeIterator()).call();
            }
            try (InputStream diffInput = temporaryDiffFile.newInputStream();){
                git.apply().setPatch(diffInput).call();
            }
            index.commit();
        }
        catch (GitAPIException e) {
            throw new MavenGitCodeFormatException(e);
        }
    }

    private AbstractTreeIterator treeIterator(DirCache dirCache) {
        return new DirCacheIterator(dirCache);
    }
}

