/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search.queries;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.search.CoreSearchQuery;
import com.couchbase.client.core.api.search.queries.CoreMatchOperator;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.protostellar.search.v1.MatchQuery;
import com.couchbase.client.protostellar.search.v1.Query;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreMatchQuery
extends CoreSearchQuery {
    private final String match;
    @Nullable
    private final String field;
    @Nullable
    private final String analyzer;
    @Nullable
    private final Integer prefixLength;
    @Nullable
    private final Integer fuzziness;
    @Nullable
    private final CoreMatchOperator operator;

    public CoreMatchQuery(String match, @Nullable String field, @Nullable String analyzer, @Nullable Integer prefixLength, @Nullable Integer fuzziness, @Nullable CoreMatchOperator operator, @Nullable Double boost) {
        super(boost);
        this.match = Validators.notNull(match, "Match");
        this.field = field;
        this.analyzer = analyzer;
        this.prefixLength = prefixLength;
        this.fuzziness = fuzziness;
        this.operator = operator;
    }

    @Override
    protected void injectParams(ObjectNode input) {
        input.put("match", this.match);
        if (this.field != null) {
            input.put("field", this.field);
        }
        if (this.analyzer != null) {
            input.put("analyzer", this.analyzer);
        }
        if (this.prefixLength != null) {
            input.put("prefix_length", this.prefixLength);
        }
        if (this.fuzziness != null) {
            input.put("fuzziness", this.fuzziness);
        }
        if (this.operator != null) {
            input.put("operator", this.operator.toString());
        }
    }

    @Override
    public Query asProtostellar() {
        MatchQuery.Builder builder = MatchQuery.newBuilder().setValue(this.match);
        if (this.boost != null) {
            builder.setBoost(this.boost.floatValue());
        }
        if (this.field != null) {
            builder.setField(this.field);
        }
        if (this.analyzer != null) {
            builder.setAnalyzer(this.analyzer);
        }
        if (this.fuzziness != null) {
            builder.setFuzziness(this.fuzziness.intValue());
        }
        if (this.operator != null) {
            builder.setOperator(this.operator == CoreMatchOperator.OR ? MatchQuery.Operator.OPERATOR_OR : MatchQuery.Operator.OPERATOR_AND);
        }
        if (this.prefixLength != null) {
            builder.setPrefixLength(this.prefixLength.intValue());
        }
        return Query.newBuilder().setMatchQuery(builder).build();
    }
}

