/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.events.io;

import com.couchbase.client.core.cnc.AbstractEvent;
import com.couchbase.client.core.cnc.Context;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.io.IoContext;
import com.couchbase.client.core.io.netty.kv.ErrorMap;
import java.time.Duration;
import java.util.Optional;

public class ErrorMapLoadedEvent
extends AbstractEvent {
    private final Optional<ErrorMap> errorMap;

    public ErrorMapLoadedEvent(IoContext ctx, Duration duration, Optional<ErrorMap> errorMap) {
        super(Event.Severity.DEBUG, Event.Category.IO, duration, (Context)ctx);
        this.errorMap = errorMap;
    }

    public Optional<ErrorMap> errorMap() {
        return this.errorMap;
    }

    @Override
    public String description() {
        return this.errorMap.map(m -> "KV Error Map successfully loaded. Map Version: " + m.version() + ", Revision: " + m.revision()).orElse("KV Error Map successfully negotiated, but no map found in body");
    }
}

