/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.io.netty.channel.EventLoopGroup;
import com.couchbase.client.core.deps.io.netty.channel.epoll.Epoll;
import com.couchbase.client.core.deps.io.netty.channel.epoll.EpollEventLoopGroup;
import com.couchbase.client.core.deps.io.netty.channel.kqueue.KQueue;
import com.couchbase.client.core.deps.io.netty.channel.kqueue.KQueueEventLoopGroup;
import com.couchbase.client.core.deps.io.netty.channel.nio.NioEventLoopGroup;
import com.couchbase.client.core.deps.io.netty.util.concurrent.DefaultThreadFactory;
import com.couchbase.client.core.env.OwnedOrExternal;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.core.util.Validators;
import java.time.Duration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class IoEnvironment {
    public static final boolean DEFAULT_NATIVE_IO_ENABLED = true;
    @Stability.Internal
    public static final int DEFAULT_EVENT_LOOP_THREAD_COUNT;
    private final boolean nativeIoEnabled;
    private final int eventLoopThreadCount;
    private final OwnedOrExternal<EventLoopGroup> managerEventLoopGroup;
    private final OwnedOrExternal<EventLoopGroup> kvEventLoopGroup;
    private final OwnedOrExternal<EventLoopGroup> queryEventLoopGroup;
    private final OwnedOrExternal<EventLoopGroup> analyticsEventLoopGroup;
    private final OwnedOrExternal<EventLoopGroup> searchEventLoopGroup;
    private final OwnedOrExternal<EventLoopGroup> viewEventLoopGroup;
    private final OwnedOrExternal<EventLoopGroup> eventingEventLoopGroup;
    private final OwnedOrExternal<EventLoopGroup> backupEventLoopGroup;

    @Deprecated
    public static IoEnvironment create() {
        return new Builder().build();
    }

    @Deprecated
    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public static Builder managerEventLoopGroup(EventLoopGroup eventLoopGroup) {
        return IoEnvironment.builder().managerEventLoopGroup(eventLoopGroup);
    }

    @Deprecated
    public static Builder kvEventLoopGroup(EventLoopGroup eventLoopGroup) {
        return IoEnvironment.builder().kvEventLoopGroup(eventLoopGroup);
    }

    @Deprecated
    public static Builder queryEventLoopGroup(EventLoopGroup eventLoopGroup) {
        return IoEnvironment.builder().queryEventLoopGroup(eventLoopGroup);
    }

    @Deprecated
    public static Builder analyticsEventLoopGroup(EventLoopGroup eventLoopGroup) {
        return IoEnvironment.builder().analyticsEventLoopGroup(eventLoopGroup);
    }

    @Deprecated
    public static Builder searchEventLoopGroup(EventLoopGroup eventLoopGroup) {
        return IoEnvironment.builder().searchEventLoopGroup(eventLoopGroup);
    }

    @Deprecated
    public static Builder viewEventLoopGroup(EventLoopGroup eventLoopGroup) {
        return IoEnvironment.builder().viewEventLoopGroup(eventLoopGroup);
    }

    @Deprecated
    public static Builder eventingEventLoopGroup(EventLoopGroup eventLoopGroup) {
        return IoEnvironment.builder().eventingEventLoopGroup(eventLoopGroup);
    }

    @Deprecated
    @Stability.Volatile
    public static Builder backupEventLoopGroup(EventLoopGroup eventLoopGroup) {
        return IoEnvironment.builder().backupEventLoopGroup(eventLoopGroup);
    }

    @Deprecated
    public static Builder eventLoopThreadCount(int eventLoopThreadCount) {
        return IoEnvironment.builder().eventLoopThreadCount(eventLoopThreadCount);
    }

    @Deprecated
    public static Builder enableNativeIo(boolean nativeIoEnabled) {
        return IoEnvironment.builder().enableNativeIo(nativeIoEnabled);
    }

    @Stability.Volatile
    Map<String, Object> exportAsMap() {
        LinkedHashMap<String, Object> export = new LinkedHashMap<String, Object>();
        export.put("nativeIoEnabled", this.nativeIoEnabled);
        export.put("eventLoopThreadCount", this.eventLoopThreadCount);
        HashSet<String> eventLoopGroups = new HashSet<String>();
        eventLoopGroups.add(this.managerEventLoopGroup.get().getClass().getSimpleName());
        eventLoopGroups.add(this.kvEventLoopGroup.get().getClass().getSimpleName());
        eventLoopGroups.add(this.queryEventLoopGroup.get().getClass().getSimpleName());
        eventLoopGroups.add(this.analyticsEventLoopGroup.get().getClass().getSimpleName());
        eventLoopGroups.add(this.searchEventLoopGroup.get().getClass().getSimpleName());
        eventLoopGroups.add(this.viewEventLoopGroup.get().getClass().getSimpleName());
        eventLoopGroups.add(this.eventingEventLoopGroup.get().getClass().getSimpleName());
        eventLoopGroups.add(this.backupEventLoopGroup.get().getClass().getSimpleName());
        export.put("eventLoopGroups", eventLoopGroups);
        return export;
    }

    private IoEnvironment(Builder builder) {
        this.nativeIoEnabled = builder.nativeIoEnabled;
        this.eventLoopThreadCount = builder.eventLoopThreadCount;
        OwnedOrExternal httpDefaultGroup = null;
        if (builder.queryEventLoopGroup == null || builder.analyticsEventLoopGroup == null || builder.searchEventLoopGroup == null || builder.viewEventLoopGroup == null || builder.eventingEventLoopGroup == null || builder.backupEventLoopGroup == null) {
            httpDefaultGroup = IoEnvironment.createEventLoopGroup(this.nativeIoEnabled, this.eventLoopThreadCount, "cb-io-http");
        }
        this.managerEventLoopGroup = builder.managerEventLoopGroup == null ? IoEnvironment.createEventLoopGroup(this.nativeIoEnabled, 1, "cb-io-manager") : builder.managerEventLoopGroup;
        this.sanityCheckEventLoop(this.managerEventLoopGroup);
        this.kvEventLoopGroup = builder.kvEventLoopGroup == null ? IoEnvironment.createEventLoopGroup(this.nativeIoEnabled, this.eventLoopThreadCount, "cb-io-kv") : builder.kvEventLoopGroup;
        this.sanityCheckEventLoop(this.kvEventLoopGroup);
        this.queryEventLoopGroup = builder.queryEventLoopGroup == null ? httpDefaultGroup : builder.queryEventLoopGroup;
        this.sanityCheckEventLoop(this.queryEventLoopGroup);
        this.analyticsEventLoopGroup = builder.analyticsEventLoopGroup == null ? httpDefaultGroup : builder.analyticsEventLoopGroup;
        this.sanityCheckEventLoop(this.analyticsEventLoopGroup);
        this.searchEventLoopGroup = builder.searchEventLoopGroup == null ? httpDefaultGroup : builder.searchEventLoopGroup;
        this.sanityCheckEventLoop(this.searchEventLoopGroup);
        this.viewEventLoopGroup = builder.viewEventLoopGroup == null ? httpDefaultGroup : builder.viewEventLoopGroup;
        this.sanityCheckEventLoop(this.viewEventLoopGroup);
        this.eventingEventLoopGroup = builder.eventingEventLoopGroup == null ? httpDefaultGroup : builder.eventingEventLoopGroup;
        this.sanityCheckEventLoop(this.eventingEventLoopGroup);
        this.backupEventLoopGroup = builder.backupEventLoopGroup == null ? httpDefaultGroup : builder.backupEventLoopGroup;
        this.sanityCheckEventLoop(this.backupEventLoopGroup);
    }

    private void sanityCheckEventLoop(OwnedOrExternal<EventLoopGroup> group) {
        if (!this.nativeIoEnabled && !(group.get() instanceof NioEventLoopGroup)) {
            throw InvalidArgumentException.fromMessage("Native IO is disabled and the EventLoopGroup is not a NioEventLoopGroup");
        }
    }

    public Supplier<EventLoopGroup> managerEventLoopGroup() {
        return this.managerEventLoopGroup::get;
    }

    public Supplier<EventLoopGroup> kvEventLoopGroup() {
        return this.kvEventLoopGroup::get;
    }

    public Supplier<EventLoopGroup> queryEventLoopGroup() {
        return this.queryEventLoopGroup::get;
    }

    public Supplier<EventLoopGroup> analyticsEventLoopGroup() {
        return this.analyticsEventLoopGroup::get;
    }

    public Supplier<EventLoopGroup> searchEventLoopGroup() {
        return this.searchEventLoopGroup::get;
    }

    public Supplier<EventLoopGroup> viewEventLoopGroup() {
        return this.viewEventLoopGroup::get;
    }

    public Supplier<EventLoopGroup> eventingEventLoopGroup() {
        return this.eventingEventLoopGroup::get;
    }

    @Stability.Volatile
    public Supplier<EventLoopGroup> backupEventLoopGroup() {
        return this.backupEventLoopGroup::get;
    }

    public boolean nativeIoEnabled() {
        return this.nativeIoEnabled;
    }

    public int eventLoopThreadCount() {
        return this.eventLoopThreadCount;
    }

    public Mono<Void> shutdown(Duration timeout) {
        return Flux.merge((Publisher[])new Publisher[]{IoEnvironment.shutdownGroup(this.managerEventLoopGroup, timeout), IoEnvironment.shutdownGroup(this.kvEventLoopGroup, timeout), IoEnvironment.shutdownGroup(this.queryEventLoopGroup, timeout), IoEnvironment.shutdownGroup(this.analyticsEventLoopGroup, timeout), IoEnvironment.shutdownGroup(this.searchEventLoopGroup, timeout), IoEnvironment.shutdownGroup(this.viewEventLoopGroup, timeout), IoEnvironment.shutdownGroup(this.eventingEventLoopGroup, timeout), IoEnvironment.shutdownGroup(this.backupEventLoopGroup, timeout)}).then();
    }

    private static Mono<Void> shutdownGroup(OwnedOrExternal<EventLoopGroup> groupSupplier, Duration timeout) {
        EventLoopGroup group;
        if (groupSupplier.isOwned() && !(group = groupSupplier.get()).isShutdown() && !group.isShuttingDown()) {
            return Mono.create(sink -> group.shutdownGracefully(0L, timeout.toMillis(), TimeUnit.MILLISECONDS).addListener(future -> {
                if (future.isSuccess()) {
                    sink.success();
                } else {
                    sink.error(future.cause());
                }
            }));
        }
        return Mono.empty();
    }

    private static OwnedOrExternal<EventLoopGroup> createEventLoopGroup(boolean nativeIoEnabled, int numThreads, String poolName) {
        DefaultThreadFactory threadFactory = new DefaultThreadFactory(poolName, true);
        if (nativeIoEnabled && Epoll.isAvailable()) {
            return OwnedOrExternal.owned(new EpollEventLoopGroup(numThreads, threadFactory));
        }
        if (nativeIoEnabled && KQueue.isAvailable()) {
            return OwnedOrExternal.owned(new KQueueEventLoopGroup(numThreads, threadFactory));
        }
        return OwnedOrExternal.owned(new NioEventLoopGroup(numThreads, threadFactory));
    }

    private static int fairThreadCount() {
        int cores = Runtime.getRuntime().availableProcessors() / 2;
        cores = Math.max(cores, 2);
        cores = Math.min(cores, 8);
        return cores;
    }

    static {
        String samplingProperty = "com.couchbase.client.core.deps.io.netty.leakDetection.samplingInterval";
        long defaultSamplingInterval = 65536L;
        if (CbCollections.isNullOrEmpty(System.getProperty("com.couchbase.client.core.deps.io.netty.leakDetection.samplingInterval"))) {
            System.setProperty("com.couchbase.client.core.deps.io.netty.leakDetection.samplingInterval", Long.toString(65536L));
        }
        DEFAULT_EVENT_LOOP_THREAD_COUNT = IoEnvironment.fairThreadCount();
    }

    public static class Builder {
        private boolean nativeIoEnabled = true;
        private OwnedOrExternal<EventLoopGroup> managerEventLoopGroup = null;
        private OwnedOrExternal<EventLoopGroup> kvEventLoopGroup = null;
        private OwnedOrExternal<EventLoopGroup> queryEventLoopGroup = null;
        private OwnedOrExternal<EventLoopGroup> analyticsEventLoopGroup = null;
        private OwnedOrExternal<EventLoopGroup> searchEventLoopGroup = null;
        private OwnedOrExternal<EventLoopGroup> viewEventLoopGroup = null;
        private OwnedOrExternal<EventLoopGroup> eventingEventLoopGroup = null;
        private OwnedOrExternal<EventLoopGroup> backupEventLoopGroup = null;
        private int eventLoopThreadCount = DEFAULT_EVENT_LOOP_THREAD_COUNT;

        public Builder managerEventLoopGroup(EventLoopGroup eventLoopGroup) {
            this.managerEventLoopGroup = Builder.checkEventLoopGroup(eventLoopGroup);
            return this;
        }

        public Builder kvEventLoopGroup(EventLoopGroup eventLoopGroup) {
            this.kvEventLoopGroup = Builder.checkEventLoopGroup(eventLoopGroup);
            return this;
        }

        public Builder queryEventLoopGroup(EventLoopGroup eventLoopGroup) {
            this.queryEventLoopGroup = Builder.checkEventLoopGroup(eventLoopGroup);
            return this;
        }

        public Builder analyticsEventLoopGroup(EventLoopGroup eventLoopGroup) {
            this.analyticsEventLoopGroup = Builder.checkEventLoopGroup(eventLoopGroup);
            return this;
        }

        public Builder searchEventLoopGroup(EventLoopGroup eventLoopGroup) {
            this.searchEventLoopGroup = Builder.checkEventLoopGroup(eventLoopGroup);
            return this;
        }

        public Builder eventingEventLoopGroup(EventLoopGroup eventLoopGroup) {
            this.eventingEventLoopGroup = Builder.checkEventLoopGroup(eventLoopGroup);
            return this;
        }

        @Stability.Volatile
        public Builder backupEventLoopGroup(EventLoopGroup eventLoopGroup) {
            this.backupEventLoopGroup = Builder.checkEventLoopGroup(eventLoopGroup);
            return this;
        }

        public Builder viewEventLoopGroup(EventLoopGroup eventLoopGroup) {
            this.viewEventLoopGroup = Builder.checkEventLoopGroup(eventLoopGroup);
            return this;
        }

        private static OwnedOrExternal<EventLoopGroup> checkEventLoopGroup(EventLoopGroup eventLoopGroup) {
            return OwnedOrExternal.external(Validators.notNull(eventLoopGroup, "EventLoopGroup"));
        }

        public Builder enableNativeIo(boolean nativeIoEnabled) {
            this.nativeIoEnabled = nativeIoEnabled;
            return this;
        }

        public Builder eventLoopThreadCount(int eventLoopThreadCount) {
            if (eventLoopThreadCount < 1) {
                throw InvalidArgumentException.fromMessage("EventLoopThreadCount cannot be smaller than 1");
            }
            this.eventLoopThreadCount = eventLoopThreadCount;
            return this;
        }

        @Stability.Internal
        public IoEnvironment build() {
            return new IoEnvironment(this);
        }
    }
}

