/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction.components;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.logging.RedactableArgument;
import java.util.Objects;

@Stability.Internal
public class DocRecord {
    private final String bucketName;
    private final String scopeName;
    private final String collectionName;
    private final String id;

    public DocRecord(String bucketName, String scopeName, String collectionName, String id) {
        this.bucketName = Objects.requireNonNull(bucketName);
        this.scopeName = Objects.requireNonNull(scopeName);
        this.collectionName = Objects.requireNonNull(collectionName);
        this.id = Objects.requireNonNull(id);
    }

    public String bucketName() {
        return this.bucketName;
    }

    public String scopeName() {
        return this.scopeName;
    }

    public String collectionName() {
        return this.collectionName;
    }

    public String id() {
        return this.id;
    }

    public static DocRecord createFrom(JsonNode o) {
        return new DocRecord(o.get("bkt").textValue(), o.get("scp").textValue(), o.get("col").textValue(), o.get("id").textValue());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(RedactableArgument.redactUser(this.bucketName));
        if (!this.scopeName.equals("_default")) {
            sb.append('.');
            sb.append(RedactableArgument.redactUser(this.scopeName));
        }
        if (!this.collectionName.equals("_default")) {
            sb.append('.');
            sb.append(RedactableArgument.redactUser(this.collectionName));
        }
        sb.append('.');
        sb.append(RedactableArgument.redactUser(this.id));
        return sb.toString();
    }
}

