/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.deps.io.netty.channel.kqueue;

import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.channel.Channel;
import com.couchbase.client.core.deps.io.netty.channel.ChannelOutboundBuffer;
import com.couchbase.client.core.deps.io.netty.channel.kqueue.AbstractKQueueChannel;
import com.couchbase.client.core.deps.io.netty.channel.kqueue.AbstractKQueueStreamChannel;
import com.couchbase.client.core.deps.io.netty.channel.kqueue.BsdSocket;
import com.couchbase.client.core.deps.io.netty.channel.kqueue.KQueueSocketChannelConfig;
import com.couchbase.client.core.deps.io.netty.channel.socket.InternetProtocolFamily;
import com.couchbase.client.core.deps.io.netty.channel.socket.ServerSocketChannel;
import com.couchbase.client.core.deps.io.netty.channel.socket.SocketChannel;
import com.couchbase.client.core.deps.io.netty.channel.unix.IovArray;
import com.couchbase.client.core.deps.io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;

public final class KQueueSocketChannel
extends AbstractKQueueStreamChannel
implements SocketChannel {
    private final KQueueSocketChannelConfig config = new KQueueSocketChannelConfig(this);

    public KQueueSocketChannel() {
        super(null, BsdSocket.newSocketStream(), false);
    }

    public KQueueSocketChannel(InternetProtocolFamily protocol) {
        super(null, BsdSocket.newSocketStream(protocol), false);
    }

    public KQueueSocketChannel(int fd) {
        super(new BsdSocket(fd));
    }

    KQueueSocketChannel(Channel parent, BsdSocket fd, InetSocketAddress remoteAddress) {
        super(parent, fd, remoteAddress);
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public KQueueSocketChannelConfig config() {
        return this.config;
    }

    @Override
    public ServerSocketChannel parent() {
        return (ServerSocketChannel)super.parent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doConnect0(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        if (this.config.isTcpFastOpenConnect()) {
            ByteBuf initialData;
            ChannelOutboundBuffer outbound = this.unsafe().outboundBuffer();
            outbound.addFlush();
            Object curr = outbound.current();
            if (curr instanceof ByteBuf && (initialData = (ByteBuf)curr).isReadable()) {
                IovArray iov = new IovArray(this.config.getAllocator().directBuffer());
                try {
                    iov.add(initialData, initialData.readerIndex(), initialData.readableBytes());
                    int bytesSent = this.socket.connectx((InetSocketAddress)localAddress, (InetSocketAddress)remoteAddress, iov, true);
                    this.writeFilter(true);
                    outbound.removeBytes(Math.abs(bytesSent));
                    boolean bl = bytesSent > 0;
                    return bl;
                }
                finally {
                    iov.release();
                }
            }
        }
        return super.doConnect0(remoteAddress, localAddress);
    }

    @Override
    protected AbstractKQueueChannel.AbstractKQueueUnsafe newUnsafe() {
        return new KQueueSocketChannelUnsafe();
    }

    private final class KQueueSocketChannelUnsafe
    extends AbstractKQueueStreamChannel.KQueueStreamUnsafe {
        private KQueueSocketChannelUnsafe() {
        }

        @Override
        protected Executor prepareToClose() {
            try {
                if (KQueueSocketChannel.this.isOpen() && KQueueSocketChannel.this.config().getSoLinger() > 0) {
                    if (KQueueSocketChannel.this.registration != null) {
                        KQueueSocketChannel.this.registration.remove();
                    }
                    return GlobalEventExecutor.INSTANCE;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }
    }
}

