/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.deps.org.xbill.DNS;

import com.couchbase.client.core.deps.org.xbill.DNS.Name;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Compression {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Compression.class);
    private static final int TABLE_SIZE = 17;
    private static final int MAX_POINTER = 16383;
    private final Entry[] table = new Entry[17];

    public void add(int pos, Name name) {
        if (pos > 16383) {
            return;
        }
        int row = (name.hashCode() & Integer.MAX_VALUE) % 17;
        Entry entry = new Entry();
        entry.name = name;
        entry.pos = pos;
        entry.next = this.table[row];
        this.table[row] = entry;
        log.trace("Adding {} at {}", (Object)name, (Object)pos);
    }

    public int get(Name name) {
        int row = (name.hashCode() & Integer.MAX_VALUE) % 17;
        int pos = -1;
        Entry entry = this.table[row];
        while (entry != null) {
            if (entry.name.equals(name)) {
                pos = entry.pos;
            }
            entry = entry.next;
        }
        log.trace("Looking for {}, found {}", (Object)name, (Object)pos);
        return pos;
    }

    private static class Entry {
        Name name;
        int pos;
        Entry next;

        private Entry() {
        }
    }
}

