/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty.kv.sasl;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.Sasl;

public class SaslHelper {
    private static final boolean PLATFORM_HAS_SASL_PLAIN = SaslHelper.initPlatformHasSaslPlain();

    private SaslHelper() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static boolean platformHasSaslPlain() {
        return PLATFORM_HAS_SASL_PLAIN;
    }

    private static boolean initPlatformHasSaslPlain() {
        try {
            return null != Sasl.createSaslClient(new String[]{"PLAIN"}, null, "couchbase", "example.com", null, SaslHelper.callbackHandler("dummyUsername", "dummyPassword"));
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static CallbackHandler callbackHandler(String username, String password) {
        return callbacks -> {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    ((NameCallback)callback).setName(username);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    ((PasswordCallback)callback).setPassword(password.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unexpected/Unsupported Callback");
            }
        };
    }
}

