/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transcoder;

import com.couchbase.client.core.lang.Tuple;
import com.couchbase.client.core.lang.Tuple2;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.kv.MutationToken;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.java.document.SerializableDocument;
import com.couchbase.client.java.error.TranscodingException;
import com.couchbase.client.java.transcoder.AbstractTranscoder;
import com.couchbase.client.java.transcoder.TranscoderUtils;
import java.io.Serializable;

public class SerializableTranscoder
extends AbstractTranscoder<SerializableDocument, Serializable> {
    @Override
    protected SerializableDocument doDecode(String id, ByteBuf content, long cas, int expiry, int flags, ResponseStatus status) throws Exception {
        if (!TranscoderUtils.hasSerializableFlags(flags)) {
            throw new TranscodingException("Flags (0x" + Integer.toHexString(flags) + ") indicate non-serialized document for id " + id + ", could not decode.");
        }
        Serializable deserialized = TranscoderUtils.deserialize(content);
        return this.newDocument(id, expiry, deserialized, cas);
    }

    @Override
    protected Tuple2<ByteBuf, Integer> doEncode(SerializableDocument document) throws Exception {
        return Tuple.create((Object)TranscoderUtils.serialize((Serializable)document.content()), (Object)TranscoderUtils.SERIALIZED_COMPAT_FLAGS);
    }

    @Override
    public SerializableDocument newDocument(String id, int expiry, Serializable content, long cas) {
        return SerializableDocument.create(id, expiry, content, cas);
    }

    @Override
    public SerializableDocument newDocument(String id, int expiry, Serializable content, long cas, MutationToken mutationToken) {
        return SerializableDocument.create(id, expiry, content, cas, mutationToken);
    }

    @Override
    public Class<SerializableDocument> documentType() {
        return SerializableDocument.class;
    }
}

