/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transactions;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.transaction.CoreTransactionGetResult;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.codec.TypeRef;
import com.couchbase.client.java.json.JsonObject;
import java.util.Objects;

public class TransactionGetResult {
    private final CoreTransactionGetResult internal;
    private final JsonSerializer serializer;

    @Stability.Internal
    TransactionGetResult(CoreTransactionGetResult internal, JsonSerializer serializer) {
        this.internal = Objects.requireNonNull(internal);
        this.serializer = Objects.requireNonNull(serializer);
    }

    public String toString() {
        return this.internal.toString();
    }

    CoreTransactionGetResult internal() {
        return this.internal;
    }

    public String id() {
        return this.internal.id();
    }

    public JsonObject contentAsObject() {
        return this.contentAs(JsonObject.class);
    }

    public <T> T contentAs(Class<T> target) {
        return this.serializer.deserialize(target, this.internal.contentAsBytes());
    }

    public <T> T contentAs(TypeRef<T> target) {
        return this.serializer.deserialize(target, this.internal.contentAsBytes());
    }

    public byte[] contentAsBytes() {
        return this.internal().contentAsBytes();
    }
}

