/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.queries;

import com.couchbase.client.core.api.search.CoreSearchQuery;
import com.couchbase.client.core.api.search.queries.CoreBooleanQuery;
import com.couchbase.client.java.search.SearchQuery;
import com.couchbase.client.java.search.queries.ConjunctionQuery;
import com.couchbase.client.java.search.queries.DisjunctionQuery;
import reactor.util.annotation.Nullable;

public class BooleanQuery
extends SearchQuery {
    @Nullable
    private ConjunctionQuery must;
    @Nullable
    private DisjunctionQuery mustNot;
    @Nullable
    private DisjunctionQuery should;

    public BooleanQuery shouldMin(int minForShould) {
        if (this.should == null) {
            this.should = new DisjunctionQuery(new SearchQuery[0]);
        }
        this.should.min(minForShould);
        return this;
    }

    public BooleanQuery must(SearchQuery ... mustQueries) {
        if (this.must == null) {
            this.must = new ConjunctionQuery(new SearchQuery[0]);
        }
        this.must.and(mustQueries);
        return this;
    }

    public BooleanQuery mustNot(SearchQuery ... mustNotQueries) {
        if (this.mustNot == null) {
            this.mustNot = new DisjunctionQuery(new SearchQuery[0]);
        }
        this.mustNot.or(mustNotQueries);
        return this;
    }

    public BooleanQuery should(SearchQuery ... shouldQueries) {
        if (this.should == null) {
            this.should = new DisjunctionQuery(new SearchQuery[0]);
        }
        this.should.or(shouldQueries);
        return this;
    }

    @Override
    public BooleanQuery boost(double boost) {
        super.boost(boost);
        return this;
    }

    @Override
    public CoreSearchQuery toCore() {
        return new CoreBooleanQuery(this.must == null ? null : this.must.toCore(), this.mustNot == null ? null : this.mustNot.toCore(), this.should == null ? null : this.should.toCore(), this.boost);
    }
}

