/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.bucket;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.util.ReactorOps;
import com.couchbase.client.java.manager.bucket.AsyncBucketManager;
import com.couchbase.client.java.manager.bucket.BucketSettings;
import com.couchbase.client.java.manager.bucket.CreateBucketOptions;
import com.couchbase.client.java.manager.bucket.DropBucketOptions;
import com.couchbase.client.java.manager.bucket.FlushBucketOptions;
import com.couchbase.client.java.manager.bucket.GetAllBucketOptions;
import com.couchbase.client.java.manager.bucket.GetBucketOptions;
import com.couchbase.client.java.manager.bucket.UpdateBucketOptions;
import java.util.Map;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class ReactiveBucketManager {
    private final AsyncBucketManager async;
    private final ReactorOps reactor;

    @Stability.Internal
    public ReactiveBucketManager(ReactorOps reactor, AsyncBucketManager async) {
        this.reactor = Objects.requireNonNull(reactor);
        this.async = Objects.requireNonNull(async);
    }

    public AsyncBucketManager async() {
        return this.async;
    }

    public Mono<Void> createBucket(BucketSettings settings) {
        return this.reactor.publishOnUserScheduler(() -> this.async.createBucket(settings));
    }

    public Mono<Void> createBucket(BucketSettings settings, CreateBucketOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.createBucket(settings, options));
    }

    public Mono<Void> updateBucket(BucketSettings settings) {
        return this.reactor.publishOnUserScheduler(() -> this.async.updateBucket(settings));
    }

    public Mono<Void> updateBucket(BucketSettings settings, UpdateBucketOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.updateBucket(settings, options));
    }

    public Mono<Void> dropBucket(String bucketName) {
        return this.reactor.publishOnUserScheduler(() -> this.async.dropBucket(bucketName));
    }

    public Mono<Void> dropBucket(String bucketName, DropBucketOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.dropBucket(bucketName, options));
    }

    public Mono<BucketSettings> getBucket(String bucketName) {
        return this.reactor.publishOnUserScheduler(() -> this.async.getBucket(bucketName));
    }

    public Mono<BucketSettings> getBucket(String bucketName, GetBucketOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.getBucket(bucketName, options));
    }

    public Mono<Map<String, BucketSettings>> getAllBuckets() {
        return this.reactor.publishOnUserScheduler(this.async::getAllBuckets);
    }

    public Mono<Map<String, BucketSettings>> getAllBuckets(GetAllBucketOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.getAllBuckets(options));
    }

    public Mono<Void> flushBucket(String bucketName) {
        return this.reactor.publishOnUserScheduler(() -> this.async.flushBucket(bucketName));
    }

    public Mono<Void> flushBucket(String bucketName, FlushBucketOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.flushBucket(bucketName, options));
    }
}

