/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.query;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.manager.CoreBuildQueryIndexOptions;
import com.couchbase.client.core.api.manager.CoreScopeAndCollection;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.CommonOptions;
import java.util.Optional;

public class BuildQueryIndexOptions
extends CommonOptions<BuildQueryIndexOptions> {
    private String scopeName;
    private String collectionName;

    private BuildQueryIndexOptions() {
    }

    public static BuildQueryIndexOptions buildDeferredQueryIndexesOptions() {
        return new BuildQueryIndexOptions();
    }

    @Deprecated
    public BuildQueryIndexOptions scopeName(String scopeName) {
        this.scopeName = Validators.notNullOrEmpty((String)scopeName, (String)"ScopeName");
        return this;
    }

    @Deprecated
    public BuildQueryIndexOptions collectionName(String collectionName) {
        this.collectionName = Validators.notNullOrEmpty((String)collectionName, (String)"CollectionName");
        return this;
    }

    @Stability.Internal
    public Built build() {
        if (this.collectionName != null && this.scopeName == null) {
            throw InvalidArgumentException.fromMessage((String)"If a collectionName is provided, a scopeName must also be provided");
        }
        if (this.scopeName != null && this.collectionName == null) {
            throw InvalidArgumentException.fromMessage((String)"If a scopeName is provided, a collectionName must also be provided");
        }
        return new Built();
    }

    public class Built
    extends CommonOptions.BuiltCommonOptions
    implements CoreBuildQueryIndexOptions {
        Built() {
        }

        public Optional<String> scopeName() {
            return Optional.ofNullable(BuildQueryIndexOptions.this.scopeName);
        }

        public Optional<String> collectionName() {
            return Optional.ofNullable(BuildQueryIndexOptions.this.collectionName);
        }

        public CoreScopeAndCollection scopeAndCollection() {
            if (BuildQueryIndexOptions.this.scopeName != null && BuildQueryIndexOptions.this.collectionName != null) {
                return new CoreScopeAndCollection(BuildQueryIndexOptions.this.scopeName, BuildQueryIndexOptions.this.collectionName);
            }
            return null;
        }

        public CoreCommonOptions commonOptions() {
            return this;
        }
    }
}

