/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.search;

import com.couchbase.client.core.Reactor;
import com.couchbase.client.core.util.ReactorOps;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.manager.search.AllowQueryingSearchIndexOptions;
import com.couchbase.client.java.manager.search.AnalyzeDocumentOptions;
import com.couchbase.client.java.manager.search.AsyncSearchIndexManager;
import com.couchbase.client.java.manager.search.DisallowQueryingSearchIndexOptions;
import com.couchbase.client.java.manager.search.DropSearchIndexOptions;
import com.couchbase.client.java.manager.search.FreezePlanSearchIndexOptions;
import com.couchbase.client.java.manager.search.GetAllSearchIndexesOptions;
import com.couchbase.client.java.manager.search.GetIndexedSearchIndexOptions;
import com.couchbase.client.java.manager.search.GetSearchIndexOptions;
import com.couchbase.client.java.manager.search.PauseIngestSearchIndexOptions;
import com.couchbase.client.java.manager.search.ResumeIngestSearchIndexOptions;
import com.couchbase.client.java.manager.search.SearchIndex;
import com.couchbase.client.java.manager.search.UnfreezePlanSearchIndexOptions;
import com.couchbase.client.java.manager.search.UpsertSearchIndexOptions;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveSearchIndexManager {
    private final AsyncSearchIndexManager asyncIndexManager;
    private final ReactorOps reactor;

    public ReactiveSearchIndexManager(ReactorOps reactor, AsyncSearchIndexManager asyncIndexManager) {
        this.reactor = Objects.requireNonNull(reactor);
        this.asyncIndexManager = Objects.requireNonNull(asyncIndexManager);
    }

    public Mono<SearchIndex> getIndex(String name, GetSearchIndexOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.asyncIndexManager.getIndex(name, options));
    }

    public Flux<SearchIndex> getAllIndexes(GetAllSearchIndexesOptions options) {
        return this.reactor.publishOnUserScheduler(Reactor.toFlux(() -> this.asyncIndexManager.getAllIndexes(options)));
    }

    public Mono<Long> getIndexedDocumentsCount(String name, GetIndexedSearchIndexOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.asyncIndexManager.getIndexedDocumentsCount(name, options));
    }

    public Flux<JsonObject> analyzeDocument(String name, JsonObject document, AnalyzeDocumentOptions options) {
        return this.reactor.publishOnUserScheduler(Reactor.toFlux(() -> this.asyncIndexManager.analyzeDocument(name, document, options)));
    }

    public Mono<Void> upsertIndex(SearchIndex index, UpsertSearchIndexOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.asyncIndexManager.upsertIndex(index, options));
    }

    public Mono<Void> dropIndex(String name, DropSearchIndexOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.asyncIndexManager.dropIndex(name, options));
    }

    public Mono<Void> pauseIngest(String name, PauseIngestSearchIndexOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.asyncIndexManager.pauseIngest(name, options));
    }

    public Mono<Void> resumeIngest(String name, ResumeIngestSearchIndexOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.asyncIndexManager.resumeIngest(name, options));
    }

    public Mono<Void> allowQuerying(String name, AllowQueryingSearchIndexOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.asyncIndexManager.allowQuerying(name, options));
    }

    public Mono<Void> disallowQuerying(String name, DisallowQueryingSearchIndexOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.asyncIndexManager.disallowQuerying(name, options));
    }

    public Mono<Void> freezePlan(String name, FreezePlanSearchIndexOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.asyncIndexManager.freezePlan(name, options));
    }

    public Mono<Void> unfreezePlan(String name, UnfreezePlanSearchIndexOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.asyncIndexManager.unfreezePlan(name, options));
    }

    public Mono<SearchIndex> getIndex(String name) {
        return this.getIndex(name, GetSearchIndexOptions.getSearchIndexOptions());
    }

    public Flux<SearchIndex> getAllIndexes() {
        return this.getAllIndexes(GetAllSearchIndexesOptions.getAllSearchIndexesOptions());
    }

    public Mono<Long> getIndexedDocumentsCount(String name) {
        return this.getIndexedDocumentsCount(name, GetIndexedSearchIndexOptions.getIndexedSearchIndexOptions());
    }

    public Flux<JsonObject> analyzeDocument(String name, JsonObject document) {
        return this.analyzeDocument(name, document, AnalyzeDocumentOptions.analyzeDocumentOptions());
    }

    public Mono<Void> upsertIndex(SearchIndex index) {
        return this.upsertIndex(index, UpsertSearchIndexOptions.upsertSearchIndexOptions());
    }

    public Mono<Void> dropIndex(String name) {
        return this.dropIndex(name, DropSearchIndexOptions.dropSearchIndexOptions());
    }

    public Mono<Void> pauseIngest(String name) {
        return this.pauseIngest(name, PauseIngestSearchIndexOptions.pauseIngestSearchIndexOptions());
    }

    public Mono<Void> resumeIngest(String name) {
        return this.resumeIngest(name, ResumeIngestSearchIndexOptions.resumeIngestSearchIndexOptions());
    }

    public Mono<Void> allowQuerying(String name) {
        return this.allowQuerying(name, AllowQueryingSearchIndexOptions.allowQueryingSearchIndexOptions());
    }

    public Mono<Void> disallowQuerying(String name) {
        return this.disallowQuerying(name, DisallowQueryingSearchIndexOptions.disallowQueryingSearchIndexOptions());
    }

    public Mono<Void> freezePlan(String name) {
        return this.freezePlan(name, FreezePlanSearchIndexOptions.freezePlanSearchIndexOptions());
    }

    public Mono<Void> unfreezePlan(String name) {
        return this.unfreezePlan(name, UnfreezePlanSearchIndexOptions.unfreezePlanSearchIndexOptions());
    }
}

