/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transactions;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.query.CoreQueryResult;
import com.couchbase.client.core.msg.query.QueryChunkRow;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.codec.TypeRef;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.query.QueryMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TransactionQueryResult {
    private final CoreQueryResult internal;
    private final JsonSerializer serializer;

    @Stability.Internal
    public TransactionQueryResult(CoreQueryResult internal, JsonSerializer serializer) {
        this.internal = Objects.requireNonNull(internal);
        this.serializer = Objects.requireNonNull(serializer);
    }

    public List<JsonObject> rowsAsObject() {
        return this.rowsAs(JsonObject.class);
    }

    public <T> List<T> rowsAs(Class<T> target) {
        List rows = this.internal.collectRows();
        ArrayList<T> converted = new ArrayList<T>(rows.size());
        for (QueryChunkRow row : rows) {
            converted.add(this.serializer.deserialize(target, row.data()));
        }
        return converted;
    }

    public <T> List<T> rowsAs(TypeRef<T> target) {
        List rows = this.internal.collectRows();
        ArrayList<T> converted = new ArrayList<T>(rows.size());
        for (QueryChunkRow row : rows) {
            converted.add(this.serializer.deserialize(target, row.data()));
        }
        return converted;
    }

    public QueryMetaData metaData() {
        return new QueryMetaData(this.internal.metaData());
    }
}

