/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources;

import com.android.resources.ResourceEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Density implements ResourceEnum
{
    XHIGH("xhdpi", "X-High Density", 320),
    HIGH("hdpi", "High Density", 240),
    TV("tvdpi", "TV Density", 213),
    MEDIUM("mdpi", "Medium Density", 160),
    LOW("ldpi", "Low Density", 120),
    NODPI("nodpi", "No Density", 0);

    public static final int DEFAULT_DENSITY = 160;
    private final String mValue;
    private final String mDisplayValue;
    private final int mDensity;

    private Density(String string2, String string3, int n2) {
        this.mValue = string2;
        this.mDisplayValue = string3;
        this.mDensity = n2;
    }

    public static Density getEnum(String string) {
        for (Density density : Density.values()) {
            if (!density.mValue.equals(string)) continue;
            return density;
        }
        return null;
    }

    public static Density getEnum(int n) {
        for (Density density : Density.values()) {
            if (density.mDensity != n) continue;
            return density;
        }
        return null;
    }

    @Override
    public String getResourceValue() {
        return this.mValue;
    }

    public int getDpiValue() {
        return this.mDensity;
    }

    public String getLegacyValue() {
        if (this != NODPI) {
            return String.format("%1$ddpi", this.getDpiValue());
        }
        return "";
    }

    @Override
    public String getShortDisplayValue() {
        return this.mDisplayValue;
    }

    @Override
    public String getLongDisplayValue() {
        return this.mDisplayValue;
    }

    public static int getIndex(Density density) {
        int n = 0;
        for (Density density2 : Density.values()) {
            if (density == density2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static Density getByIndex(int n) {
        int n2 = 0;
        for (Density density : Density.values()) {
            if (n2 == n) {
                return density;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public boolean isFakeValue() {
        return false;
    }

    @Override
    public boolean isValidValueForDevice() {
        return this != NODPI;
    }
}

