/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ResourceType {
    ANIM("anim", "Animation", new String[0]),
    ANIMATOR("animator", "Animator", new String[0]),
    ARRAY("array", "Array", "string-array", "integer-array"),
    ATTR("attr", "Attr", new String[0]),
    BOOL("bool", "Boolean", new String[0]),
    COLOR("color", "Color", new String[0]),
    DECLARE_STYLEABLE("declare-styleable", "Declare Stylable", new String[0]),
    DIMEN("dimen", "Dimension", new String[0]),
    DRAWABLE("drawable", "Drawable", new String[0]),
    FRACTION("fraction", "Fraction", new String[0]),
    ID("id", "ID", new String[0]),
    INTEGER("integer", "Integer", new String[0]),
    INTERPOLATOR("interpolator", "Interpolator", new String[0]),
    LAYOUT("layout", "Layout", new String[0]),
    MENU("menu", "Menu", new String[0]),
    MIPMAP("mipmap", "Mip Map", new String[0]),
    PLURALS("plurals", "Plurals", new String[0]),
    RAW("raw", "Raw", new String[0]),
    STRING("string", "String", new String[0]),
    STYLE("style", "Style", new String[0]),
    STYLEABLE("styleable", "Styleable", new String[0]),
    XML("xml", "XML", new String[0]),
    PUBLIC("public", "###", new String[0]);

    private final String mName;
    private final String mDisplayName;
    private final String[] mAlternateXmlNames;

    private ResourceType(String string2, String string3, String ... stringArray) {
        this.mName = string2;
        this.mDisplayName = string3;
        this.mAlternateXmlNames = stringArray;
    }

    public String getName() {
        return this.mName;
    }

    public String getDisplayName() {
        return this.mDisplayName;
    }

    public static ResourceType getEnum(String string) {
        for (ResourceType resourceType : ResourceType.values()) {
            if (resourceType.mName.equals(string)) {
                return resourceType;
            }
            if (resourceType.mAlternateXmlNames == null) continue;
            for (String string2 : resourceType.mAlternateXmlNames) {
                if (!string2.equals(string)) continue;
                return resourceType;
            }
        }
        return null;
    }

    public static String[] getNames() {
        ResourceType[] resourceTypeArray = ResourceType.values();
        String[] stringArray = new String[resourceTypeArray.length];
        for (int i = resourceTypeArray.length - 1; i >= 0; --i) {
            stringArray[i] = resourceTypeArray[i].getName();
        }
        return stringArray;
    }

    public String toString() {
        return this.getName();
    }
}

