/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.xml;

import com.android.resources.Keyboard;
import com.android.resources.Navigation;
import com.android.resources.TouchScreen;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;

public final class ManifestData {
    public static final int MIN_SDK_CODENAME = 0;
    public static final int GL_ES_VERSION_NOT_SET = -1;
    String mPackage;
    Integer mVersionCode = null;
    final ArrayList<Activity> mActivities = new ArrayList();
    Activity mLauncherActivity = null;
    Set<String> mProcesses = null;
    Boolean mDebuggable = null;
    private String mMinSdkVersionString = null;
    private int mMinSdkVersion = 1;
    private int mTargetSdkVersion = 0;
    final ArrayList<Instrumentation> mInstrumentations = new ArrayList();
    final ArrayList<UsesLibrary> mLibraries = new ArrayList();
    final ArrayList<UsesFeature> mFeatures = new ArrayList();
    SupportsScreens mSupportsScreensFromManifest;
    SupportsScreens mSupportsScreensValues;
    UsesConfiguration mUsesConfiguration;

    public String getPackage() {
        return this.mPackage;
    }

    public Integer getVersionCode() {
        return this.mVersionCode;
    }

    public Activity[] getActivities() {
        return this.mActivities.toArray(new Activity[this.mActivities.size()]);
    }

    public Activity getLauncherActivity() {
        return this.mLauncherActivity;
    }

    public String[] getProcesses() {
        if (this.mProcesses != null) {
            return this.mProcesses.toArray(new String[this.mProcesses.size()]);
        }
        return new String[0];
    }

    public Boolean getDebuggable() {
        return this.mDebuggable;
    }

    public String getMinSdkVersionString() {
        return this.mMinSdkVersionString;
    }

    public void setMinSdkVersionString(String string) {
        this.mMinSdkVersionString = string;
        if (this.mMinSdkVersionString != null) {
            try {
                this.mMinSdkVersion = Integer.parseInt(this.mMinSdkVersionString);
            }
            catch (NumberFormatException numberFormatException) {
                this.mMinSdkVersion = 0;
            }
        }
    }

    public int getMinSdkVersion() {
        return this.mMinSdkVersion;
    }

    public void setTargetSdkVersionString(String string) {
        if (string != null) {
            try {
                this.mTargetSdkVersion = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public int getTargetSdkVersion() {
        if (this.mTargetSdkVersion == 0) {
            return this.getMinSdkVersion();
        }
        return this.mTargetSdkVersion;
    }

    public Instrumentation[] getInstrumentations() {
        return this.mInstrumentations.toArray(new Instrumentation[this.mInstrumentations.size()]);
    }

    public UsesLibrary[] getUsesLibraries() {
        return this.mLibraries.toArray(new UsesLibrary[this.mLibraries.size()]);
    }

    public UsesFeature[] getUsesFeatures() {
        return this.mFeatures.toArray(new UsesFeature[this.mFeatures.size()]);
    }

    public int getGlEsVersion() {
        for (UsesFeature usesFeature : this.mFeatures) {
            if (usesFeature.mGlEsVersion <= 0) continue;
            return usesFeature.mGlEsVersion;
        }
        return -1;
    }

    public SupportsScreens getSupportsScreensFromManifest() {
        return this.mSupportsScreensFromManifest;
    }

    public synchronized SupportsScreens getSupportsScreensValues() {
        if (this.mSupportsScreensValues == null) {
            this.mSupportsScreensValues = this.mSupportsScreensFromManifest == null ? SupportsScreens.getDefaultValues(this.getTargetSdkVersion()) : this.mSupportsScreensFromManifest.resolveSupportsScreensValues(this.getTargetSdkVersion());
        }
        return this.mSupportsScreensValues;
    }

    public UsesConfiguration getUsesConfiguration() {
        return this.mUsesConfiguration;
    }

    void addProcessName(String string) {
        if (this.mProcesses == null) {
            this.mProcesses = new TreeSet<String>();
        }
        if (string.startsWith(":")) {
            this.mProcesses.add(this.mPackage + string);
        } else {
            this.mProcesses.add(string);
        }
    }

    public static final class UsesConfiguration {
        Boolean mReqFiveWayNav;
        Boolean mReqHardKeyboard;
        Keyboard mReqKeyboardType;
        TouchScreen mReqTouchScreen;
        Navigation mReqNavigation;

        public Boolean getReqFiveWayNav() {
            return this.mReqFiveWayNav;
        }

        public Navigation getReqNavigation() {
            return this.mReqNavigation;
        }

        public Boolean getReqHardKeyboard() {
            return this.mReqHardKeyboard;
        }

        public Keyboard getReqKeyboardType() {
            return this.mReqKeyboardType;
        }

        public TouchScreen getReqTouchScreen() {
            return this.mReqTouchScreen;
        }
    }

    public static final class UsesFeature {
        String mName;
        int mGlEsVersion = 0;
        Boolean mRequired = Boolean.TRUE;

        public String getName() {
            return this.mName;
        }

        public int getGlEsVersion() {
            return this.mGlEsVersion;
        }

        public Boolean getRequired() {
            return this.mRequired;
        }
    }

    public static final class UsesLibrary {
        String mName;
        Boolean mRequired = Boolean.TRUE;

        public String getName() {
            return this.mName;
        }

        public Boolean getRequired() {
            return this.mRequired;
        }
    }

    public static final class SupportsScreens {
        private Boolean mResizeable;
        private Boolean mAnyDensity;
        private Boolean mSmallScreens;
        private Boolean mNormalScreens;
        private Boolean mLargeScreens;

        public SupportsScreens() {
        }

        public SupportsScreens(String string) {
            String[] stringArray = string.split("\\|");
            this.mAnyDensity = Boolean.valueOf(stringArray[0]);
            this.mResizeable = Boolean.valueOf(stringArray[1]);
            this.mSmallScreens = Boolean.valueOf(stringArray[2]);
            this.mNormalScreens = Boolean.valueOf(stringArray[3]);
            this.mLargeScreens = Boolean.valueOf(stringArray[4]);
        }

        public static SupportsScreens getDefaultValues(int n) {
            SupportsScreens supportsScreens = new SupportsScreens();
            supportsScreens.mNormalScreens = Boolean.TRUE;
            supportsScreens.mLargeScreens = n <= 3 ? Boolean.FALSE : Boolean.TRUE;
            supportsScreens.mSmallScreens = supportsScreens.mLargeScreens;
            supportsScreens.mAnyDensity = supportsScreens.mLargeScreens;
            supportsScreens.mResizeable = supportsScreens.mLargeScreens;
            return supportsScreens;
        }

        public SupportsScreens resolveSupportsScreensValues(int n) {
            SupportsScreens supportsScreens = SupportsScreens.getDefaultValues(n);
            if (this.mResizeable != null) {
                supportsScreens.mResizeable = this.mResizeable;
            }
            if (this.mAnyDensity != null) {
                supportsScreens.mAnyDensity = this.mAnyDensity;
            }
            if (this.mSmallScreens != null) {
                supportsScreens.mSmallScreens = this.mSmallScreens;
            }
            if (this.mNormalScreens != null) {
                supportsScreens.mNormalScreens = this.mNormalScreens;
            }
            if (this.mLargeScreens != null) {
                supportsScreens.mLargeScreens = this.mLargeScreens;
            }
            return supportsScreens;
        }

        public Boolean getResizeable() {
            return this.mResizeable;
        }

        void setResizeable(Boolean bl) {
            this.mResizeable = this.getConstantBoolean(bl);
        }

        public Boolean getAnyDensity() {
            return this.mAnyDensity;
        }

        void setAnyDensity(Boolean bl) {
            this.mAnyDensity = this.getConstantBoolean(bl);
        }

        public Boolean getSmallScreens() {
            return this.mSmallScreens;
        }

        void setSmallScreens(Boolean bl) {
            this.mSmallScreens = this.getConstantBoolean(bl);
        }

        public Boolean getNormalScreens() {
            return this.mNormalScreens;
        }

        void setNormalScreens(Boolean bl) {
            this.mNormalScreens = this.getConstantBoolean(bl);
        }

        public Boolean getLargeScreens() {
            return this.mLargeScreens;
        }

        void setLargeScreens(Boolean bl) {
            this.mLargeScreens = this.getConstantBoolean(bl);
        }

        private Boolean getConstantBoolean(Boolean bl) {
            if (bl != null) {
                if (bl.equals(Boolean.TRUE)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            return null;
        }

        public boolean equals(Object object) {
            if (object instanceof SupportsScreens) {
                SupportsScreens supportsScreens = (SupportsScreens)object;
                return this.mResizeable == supportsScreens.mResizeable && this.mAnyDensity == supportsScreens.mAnyDensity && this.mSmallScreens == supportsScreens.mSmallScreens && this.mNormalScreens == supportsScreens.mNormalScreens && this.mLargeScreens == supportsScreens.mLargeScreens;
            }
            return false;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.mAnyDensity == null ? 0 : this.mAnyDensity.hashCode());
            n = 31 * n + (this.mLargeScreens == null ? 0 : this.mLargeScreens.hashCode());
            n = 31 * n + (this.mNormalScreens == null ? 0 : this.mNormalScreens.hashCode());
            n = 31 * n + (this.mResizeable == null ? 0 : this.mResizeable.hashCode());
            n = 31 * n + (this.mSmallScreens == null ? 0 : this.mSmallScreens.hashCode());
            return n;
        }

        public boolean hasSameScreenSupportAs(SupportsScreens supportsScreens) {
            return this.mSmallScreens == supportsScreens.mSmallScreens && this.mNormalScreens == supportsScreens.mNormalScreens && this.mLargeScreens == supportsScreens.mLargeScreens;
        }

        public boolean hasStrictlyDifferentScreenSupportAs(SupportsScreens supportsScreens) {
            return !(this.mSmallScreens == Boolean.TRUE && supportsScreens.mSmallScreens == Boolean.TRUE || this.mNormalScreens == Boolean.TRUE && supportsScreens.mNormalScreens == Boolean.TRUE || this.mLargeScreens == Boolean.TRUE && supportsScreens.mLargeScreens == Boolean.TRUE);
        }

        public int compareScreenSizesWith(SupportsScreens supportsScreens) {
            if (!this.hasStrictlyDifferentScreenSupportAs(supportsScreens)) {
                throw new IllegalArgumentException("The two instances are not strictly different.");
            }
            if (this.overlapWith(supportsScreens)) {
                throw new IllegalArgumentException("The two instances overlap each other.");
            }
            int n = this.mLargeScreens.compareTo(supportsScreens.mLargeScreens);
            if (n != 0) {
                return n;
            }
            n = this.mNormalScreens.compareTo(supportsScreens.mNormalScreens);
            if (n != 0) {
                return n;
            }
            n = this.mSmallScreens.compareTo(supportsScreens.mSmallScreens);
            if (n != 0) {
                return n;
            }
            return 0;
        }

        public String getEncodedValues() {
            return String.format("%1$s|%2$s|%3$s|%4$s|%5$s", this.mAnyDensity, this.mResizeable, this.mSmallScreens, this.mNormalScreens, this.mLargeScreens);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            if (Boolean.TRUE.equals(this.mSmallScreens)) {
                bl = true;
                stringBuilder.append("small");
            }
            if (Boolean.TRUE.equals(this.mNormalScreens)) {
                if (bl) {
                    stringBuilder.append(", ");
                }
                bl = true;
                stringBuilder.append("normal");
            }
            if (Boolean.TRUE.equals(this.mLargeScreens)) {
                if (bl) {
                    stringBuilder.append(", ");
                }
                bl = true;
                stringBuilder.append("large");
            }
            if (!bl) {
                stringBuilder.append("<none>");
            }
            return stringBuilder.toString();
        }

        public boolean overlapWith(SupportsScreens supportsScreens) {
            if (this.mSmallScreens == null || this.mNormalScreens == null || this.mLargeScreens == null || supportsScreens.mSmallScreens == null || supportsScreens.mNormalScreens == null || supportsScreens.mLargeScreens == null) {
                throw new IllegalArgumentException("Some screen sizes Boolean are not initialized");
            }
            if (this.mSmallScreens == Boolean.TRUE && this.mNormalScreens == Boolean.FALSE && this.mLargeScreens == Boolean.TRUE) {
                return supportsScreens.mNormalScreens == Boolean.TRUE;
            }
            if (supportsScreens.mSmallScreens == Boolean.TRUE && supportsScreens.mNormalScreens == Boolean.FALSE && supportsScreens.mLargeScreens == Boolean.TRUE) {
                return this.mNormalScreens == Boolean.TRUE;
            }
            return false;
        }
    }

    public static final class Activity {
        private final String mName;
        private final boolean mIsExported;
        private boolean mHasAction = false;
        private boolean mHasMainAction = false;
        private boolean mHasLauncherCategory = false;

        public Activity(String string, boolean bl) {
            this.mName = string;
            this.mIsExported = bl;
        }

        public String getName() {
            return this.mName;
        }

        public boolean isExported() {
            return this.mIsExported;
        }

        public boolean hasAction() {
            return this.mHasAction;
        }

        public boolean isHomeActivity() {
            return this.mHasMainAction && this.mHasLauncherCategory;
        }

        void setHasAction(boolean bl) {
            this.mHasAction = bl;
        }

        void resetIntentFilter() {
            if (!this.isHomeActivity()) {
                this.mHasLauncherCategory = false;
                this.mHasMainAction = false;
            }
        }

        void setHasMainAction(boolean bl) {
            this.mHasMainAction = bl;
        }

        void setHasLauncherCategory(boolean bl) {
            this.mHasLauncherCategory = bl;
        }
    }

    public static final class Instrumentation {
        private final String mName;
        private final String mTargetPackage;

        Instrumentation(String string, String string2) {
            this.mName = string;
            this.mTargetPackage = string2;
        }

        public String getName() {
            return this.mName;
        }

        public String getTargetPackage() {
            return this.mTargetPackage;
        }
    }
}

