/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.api;

import com.crashlytics.api.Organization;
import com.crashlytics.tools.android.DeveloperTools;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.json.simple.JSONObject;

public class App {
    private static final Object JSON_ID = "id";
    private static final String JSON_NAME = "name";
    private static final String JSON_BUNDLE_ID = "bundle_identifier";
    private static final String JSON_PLATFORM = "platform";
    private static final String JSON_STATUS = "status";
    private static final String JSON_IMPACTED_DEVICE_COUNT = "impacted_devices_count";
    private static final String JSON_UNRESOLVED_ISSUE_COUNT = "unresolved_issues_count";
    private static final String JSON_ICON64_URL = "icon_url";
    private final String _id;
    private final String _name;
    private final String _bundleId;
    private final String _platform;
    private final String _icon64_url;
    private final int _impactedDeviceCount;
    private final int _unresolvedIssueCount;
    private final Organization _org;
    private final Status _status;

    private static Status statusFromString(String statusStr) {
        try {
            return Status.valueOf(statusStr.toUpperCase());
        }
        catch (Exception e) {
            DeveloperTools.logE("Unknown status string: " + statusStr, e);
            return Status.UNKNOWN;
        }
    }

    public App(String id, String name, String bundleId, String platform, String icon64_url, int impactedDeviceCount, int unresolvedIssueCount, Organization org, Status status) {
        if (bundleId == null || bundleId.isEmpty()) {
            throw new IllegalArgumentException("Invalid bundleId: " + bundleId);
        }
        this._id = id;
        this._name = name;
        this._bundleId = bundleId;
        this._platform = platform;
        this._icon64_url = icon64_url;
        this._org = org;
        this._status = status;
        this._impactedDeviceCount = impactedDeviceCount;
        this._unresolvedIssueCount = unresolvedIssueCount;
    }

    public App(JSONObject json, Organization org) {
        this((String)json.get(JSON_ID), (String)json.get(JSON_NAME), (String)json.get(JSON_BUNDLE_ID), (String)json.get(JSON_PLATFORM), (String)json.get(JSON_ICON64_URL), ((Long)json.get(JSON_IMPACTED_DEVICE_COUNT)).intValue(), ((Long)json.get(JSON_UNRESOLVED_ISSUE_COUNT)).intValue(), org, App.statusFromString((String)json.get(JSON_STATUS)));
    }

    public String getId() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public String getBundleIdForDisplay() {
        return this._bundleId;
    }

    public boolean bundleIdEquals(String bundleId) {
        return this._bundleId.equalsIgnoreCase(bundleId);
    }

    public String getPlatform() {
        return this._platform;
    }

    public String getIcon64URL() {
        return this._icon64_url;
    }

    public int getImpactedDeviceCount() {
        return this._impactedDeviceCount;
    }

    public int getUnresolvedIssueCount() {
        return this._unresolvedIssueCount;
    }

    public Organization getOrganization() {
        return this._org;
    }

    public Status getStatus() {
        return this._status;
    }

    public int hashCode() {
        return this._bundleId.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return this._bundleId.equals(((App)obj)._bundleId);
    }

    public String toString() {
        return this._bundleId + ":" + this._name;
    }

    public BufferedImage getIconImageOrNull() {
        BufferedImage returnIconImage = null;
        String iconURL = this.getIcon64URL();
        try {
            if (!iconURL.startsWith("http")) {
                iconURL = DeveloperTools.getWebApi().getBaseApiUrl() + iconURL;
            }
            returnIconImage = ImageIO.read(new URL(iconURL));
        }
        catch (IOException e) {
            DeveloperTools.logE("Could not get image from " + iconURL, e);
        }
        return returnIconImage;
    }

    public static enum Status {
        ACTIVATED,
        CONFIGURED,
        NEW,
        DELETED,
        UNKNOWN;

    }
}

