/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.utils.abx;

import java.io.ByteArrayInputStream;
import java.io.IOException;

public class AbxUtils {
    private static final char[] hexStr = new char[]{'A', 'B', 'C', 'D', 'E', 'F'};
    public static final int DEFAULT_PACKAGE_ID = 127;

    public static String toHex(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        String hex = "";
        for (int i = 0; i < bytes.length; ++i) {
            int num = 0xFF & bytes[i];
            int div = num / 16;
            int rem = num % 16;
            hex = div > 9 ? hex + " 0x" + hexStr[div -= 10] : hex + " 0x" + div;
            hex = rem > 9 ? hex + "" + hexStr[rem -= 10] : hex + "" + rem;
        }
        return hex;
    }

    public static int toInt(byte[] bytes, boolean isBigEndian) {
        int x = 0;
        int numOfBytes = bytes.length;
        if (numOfBytes > 4) {
            numOfBytes = 4;
        }
        for (int i = 0; i < numOfBytes; ++i) {
            if (i == 0) {
                if (isBigEndian) {
                    x = 0xFF & bytes[i];
                    continue;
                }
                x = 0xFF & bytes[numOfBytes - 1];
                continue;
            }
            x = isBigEndian ? x << 8 | 0xFF & bytes[i] : x << 8 | 0xFF & bytes[numOfBytes - 1 - i];
        }
        return x;
    }

    public static long toLong(byte[] bytes, boolean isBigEndian) {
        long x = 0L;
        int numOfBytes = bytes.length;
        if (numOfBytes > 8) {
            numOfBytes = 8;
        }
        for (int i = 0; i < numOfBytes; ++i) {
            if (i == 0) {
                if (isBigEndian) {
                    x = 0xFF & bytes[i];
                    continue;
                }
                x = 0xFF & bytes[numOfBytes - 1];
                continue;
            }
            x = isBigEndian ? x << 8 | (long)(0xFF & bytes[i]) : x << 8 | (long)(0xFF & bytes[numOfBytes - 1 - i]);
        }
        return x;
    }

    public static String toString(byte[] charBuf, boolean isBigEndian) throws IOException {
        int code;
        StringBuffer strBuf = new StringBuffer();
        byte[] buf_2 = new byte[2];
        ByteArrayInputStream in = new ByteArrayInputStream(charBuf);
        while (in.read(buf_2) != -1 && (code = AbxUtils.toInt(buf_2, isBigEndian)) != 0) {
            strBuf.append((char)code);
        }
        return strBuf.toString();
    }

    public static int resIdFromEntryIndex(int packageId, int typeIndex, int entryIndex) {
        return 0xFF000000 & packageId << 24 | 0xFF0000 & typeIndex + 1 << 16 | 0xFFFF & entryIndex;
    }

    public static int resIdFromDefaultStringEntryIndex(int typeIndex, int entryIndex) {
        return AbxUtils.resIdFromEntryIndex(127, typeIndex, entryIndex);
    }

    public static int entryIndexFromResId(int resId) {
        return resId & 0xFFFF;
    }

    public static boolean verifyPackageIdFromResIdIsDefault(int resId) {
        return resId >> 24 == 127;
    }
}

