/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.build;

import com.android.sdklib.build.ApkBuilder;
import com.android.sdklib.build.ApkCreationException;
import com.android.sdklib.build.DuplicateFileException;
import com.android.sdklib.build.SealedApkException;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.regex.Pattern;

public final class ApkBuilderMain {
    private static final Pattern PATTERN_JAR_EXT = Pattern.compile("^.+\\.jar$", 2);

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            ApkBuilderMain.printUsageAndQuit();
        }
        System.err.println("\nTHIS TOOL IS DEPRECATED. See --help for more information.\n");
        try {
            Object object;
            File file = new File(stringArray[0]);
            File file2 = null;
            ArrayList<File> arrayList = new ArrayList<File>();
            ArrayList<File> arrayList2 = new ArrayList<File>();
            ArrayList<File> arrayList3 = new ArrayList<File>();
            ArrayList<File> arrayList4 = new ArrayList<File>();
            boolean bl = false;
            boolean bl2 = true;
            boolean bl3 = false;
            int n = 1;
            do {
                if ("-v".equals(object = stringArray[n++])) {
                    bl = true;
                    continue;
                }
                if ("-d".equals(object)) {
                    bl3 = true;
                    continue;
                }
                if ("-u".equals(object)) {
                    bl2 = false;
                    continue;
                }
                if ("-z".equals(object)) {
                    if (n == stringArray.length) {
                        ApkBuilderMain.printAndExit("Missing value for -z");
                    }
                    arrayList.add(new File(stringArray[n++]));
                    continue;
                }
                if ("-f".equals(object)) {
                    if (file2 != null) {
                        ApkBuilderMain.printAndExit("Can't have more than one dex file (-f)");
                    }
                    if (n == stringArray.length) {
                        ApkBuilderMain.printAndExit("Missing value for -f");
                    }
                    file2 = new File(stringArray[n++]);
                    continue;
                }
                if ("-rf".equals(object)) {
                    if (n == stringArray.length) {
                        ApkBuilderMain.printAndExit("Missing value for -rf");
                    }
                    arrayList2.add(new File(stringArray[n++]));
                    continue;
                }
                if ("-rj".equals(object)) {
                    if (n == stringArray.length) {
                        ApkBuilderMain.printAndExit("Missing value for -rj");
                    }
                    arrayList3.add(new File(stringArray[n++]));
                    continue;
                }
                if ("-nf".equals(object)) {
                    if (n == stringArray.length) {
                        ApkBuilderMain.printAndExit("Missing value for -nf");
                    }
                    arrayList4.add(new File(stringArray[n++]));
                    continue;
                }
                if ("-storetype".equals(object)) {
                    if (n != stringArray.length) continue;
                    ApkBuilderMain.printAndExit("Missing value for -storetype");
                    continue;
                }
                ApkBuilderMain.printAndExit("Unknown argument: " + (String)object);
            } while (n < stringArray.length);
            if (arrayList.size() == 0) {
                ApkBuilderMain.printAndExit("No zip archive, there must be one for the resources");
            }
            object = new ApkBuilder(file, (File)arrayList.get(0), file2, bl2 ? ApkBuilder.getDebugKeystore() : null, bl ? System.out : null);
            ((ApkBuilder)object).setDebugMode(bl3);
            for (int i = 1; i < arrayList.size(); ++i) {
                ((ApkBuilder)object).addZipFile((File)arrayList.get(i));
            }
            for (File file3 : arrayList2) {
                ((ApkBuilder)object).addSourceFolder(file3);
            }
            for (File file3 : arrayList3) {
                if (file3.isDirectory()) {
                    String[] stringArray2;
                    for (String string : stringArray2 = file3.list(new FilenameFilter(){

                        public boolean accept(File file, String string) {
                            return PATTERN_JAR_EXT.matcher(string).matches();
                        }
                    })) {
                        ((ApkBuilder)object).addResourcesFromJar(new File(file3, string));
                    }
                    continue;
                }
                ((ApkBuilder)object).addResourcesFromJar(file3);
            }
            for (File file3 : arrayList4) {
                ((ApkBuilder)object).addNativeLibraries(file3);
            }
            ((ApkBuilder)object).sealApk();
        }
        catch (ApkCreationException apkCreationException) {
            ApkBuilderMain.printAndExit(apkCreationException.getMessage());
        }
        catch (DuplicateFileException duplicateFileException) {
            ApkBuilderMain.printAndExit(String.format("Found duplicate file for APK: %1$s\nOrigin 1: %2$s\nOrigin 2: %3$s", duplicateFileException.getArchivePath(), duplicateFileException.getFile1(), duplicateFileException.getFile2()));
        }
        catch (SealedApkException sealedApkException) {
            ApkBuilderMain.printAndExit(sealedApkException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void printUsageAndQuit() {
        System.err.println("\n\n<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        System.err.println("THIS TOOL IS DEPRECATED and may stop working at any time!\n");
        System.err.println("If you wish to use apkbuilder for a custom build system, please look at the");
        System.err.println("com.android.sdklib.build.ApkBuilder which provides support for");
        System.err.println("recent build improvements including library projects.");
        System.err.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n\n");
        System.err.println("A command line tool to package an Android application from various sources.");
        System.err.println("Usage: apkbuilder <out archive> [-v][-u][-storetype STORE_TYPE] [-z inputzip]");
        System.err.println("            [-f inputfile] [-rf input-folder] [-rj -input-path]");
        System.err.println("");
        System.err.println("    -v      Verbose.");
        System.err.println("    -d      Debug Mode: Includes debug files in the APK file.");
        System.err.println("    -u      Creates an unsigned package.");
        System.err.println("    -storetype Forces the KeyStore type. If ommited the default is used.");
        System.err.println("");
        System.err.println("    -z      Followed by the path to a zip archive.");
        System.err.println("            Adds the content of the application package.");
        System.err.println("");
        System.err.println("    -f      Followed by the path to a file.");
        System.err.println("            Adds the file to the application package.");
        System.err.println("");
        System.err.println("    -rf     Followed by the path to a source folder.");
        System.err.println("            Adds the java resources found in that folder to the application");
        System.err.println("            package, while keeping their path relative to the source folder.");
        System.err.println("");
        System.err.println("    -rj     Followed by the path to a jar file or a folder containing");
        System.err.println("            jar files.");
        System.err.println("            Adds the java resources found in the jar file(s) to the application");
        System.err.println("            package.");
        System.err.println("");
        System.err.println("    -nf     Followed by the root folder containing native libraries to");
        System.err.println("            include in the application package.");
        System.exit(1);
    }

    private static void printAndExit(String ... stringArray) {
        for (String string : stringArray) {
            System.err.println(string);
        }
        System.exit(1);
    }

    private ApkBuilderMain() {
    }
}

