/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project;

import java.io.File;
import java.io.IOException;

public class AndroidProjectStructure {
    public static String EXISTS = "Exists";
    public static String DOES_NOT_EXIST = "Doesn't Exist";
    private final File _projectRootDir;
    private final File _manifestFile;
    private final File _resDir;
    private final File _dataPath;
    private final File _propertyFile;

    public AndroidProjectStructure(File projectRootDir, File manifestFile, File resDir, File dataPath, File propertyFile) {
        this._projectRootDir = projectRootDir;
        this._manifestFile = manifestFile;
        this._resDir = resDir;
        this._dataPath = dataPath;
        this._propertyFile = propertyFile;
    }

    public File getManifestFile() {
        return this._manifestFile;
    }

    public File getProjectRootDir() {
        return this._projectRootDir;
    }

    public File getResourceDir() {
        return this._resDir;
    }

    public boolean allExists() {
        return this._projectRootDir.exists() && this._manifestFile.exists() && this._resDir.exists();
    }

    public String toString() {
        return String.format("Root: %s (%s), Manifest: %s (%s), Res: %s (%s), Data: %s (%s)", this._projectRootDir, this.existsString(this._projectRootDir.exists()), this._manifestFile, this.existsString(this._manifestFile.exists()), this._resDir, this.existsString(this._resDir.exists()), this._dataPath, this.existsString(this._dataPath.exists()));
    }

    public String existsString(boolean exists) {
        return exists ? EXISTS : DOES_NOT_EXIST;
    }

    public File getProjectDataPath() throws IOException {
        return this._dataPath;
    }

    public File getPropertyFile() {
        return this._propertyFile;
    }
}

