/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android;

import com.crashlytics.api.Software;
import com.crashlytics.api.WebApi;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.EmptySDK;
import com.crashlytics.tools.android.FileBasedSDK;
import com.crashlytics.tools.android.PersistedSDK;
import com.crashlytics.tools.android.ReleaseNotesManager;
import com.crashlytics.tools.android.SDK;
import com.crashlytics.tools.android.SDKManager;
import com.crashlytics.tools.android.SDKManagerListener;
import com.crashlytics.tools.utils.JarUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class DefaultSDKManager
implements SDKManager {
    private final File _sdksDir;
    private final List<SDKManagerListener> listeners = new CopyOnWriteArrayList<SDKManagerListener>();
    private final ReleaseNotesManager _releaseNotesManager;

    public DefaultSDKManager(File sdksDir, ReleaseNotesManager releaseNotesManager) {
        this._sdksDir = sdksDir;
        this._releaseNotesManager = releaseNotesManager;
    }

    @Override
    public boolean copyCachedSDK(String apiKey, PersistedSDK currentSDK) throws IOException {
        String currentVersion = currentSDK.getVersion();
        SDK cachedSDK = this.getCachedSdk(apiKey);
        String replaceVersion = cachedSDK.getVersion();
        if (replaceVersion == null) {
            return false;
        }
        if (currentVersion == null || JarUtils.VERSION_STRING_COMPARATOR.compare(replaceVersion, currentVersion) > 0) {
            DeveloperTools.logD("Updating " + currentSDK + " (" + currentVersion + " -> " + replaceVersion + ")");
            currentSDK.replaceWith(cachedSDK);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateCachedSDK(WebApi api, String apiKey) throws IOException {
        Software sw;
        String currentVersion = this.getCachedSdk(apiKey).getVersion();
        if (currentVersion == null) {
            DeveloperTools.logD("Unable to parse cached SDK version for API key " + apiKey + ". Assuming no SDK present.");
            currentVersion = "0.0.0";
        }
        if ((sw = api.getAndroidSDK(apiKey, currentVersion)) == null) {
            return false;
        }
        boolean releaseNotesDownloaded = this._releaseNotesManager.downloadReleaseNotes();
        if (!releaseNotesDownloaded) {
            DeveloperTools.logW("Failed to download release notes during SDK update - propagating failure to entire download.", null);
            return false;
        }
        File destDir = new File(this._sdksDir, apiKey);
        destDir.mkdirs();
        URL sdkDownload = new URL(sw.getDownloadUrl());
        File sdkDest = new File(destDir, "crashlytics.jar");
        boolean sdkDownloadSuccess = api.downloadFile(sdkDownload, sdkDest);
        if (sdkDownloadSuccess && this._releaseNotesManager.commitDownloadedReleaseNotes()) {
            this.fireNewReleaseNotesAvailable();
        }
        return sdkDownloadSuccess;
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean isSdkAvailable(String apiKey) {
        return this.getCachedSdkFile(apiKey).exists();
    }

    private SDK getCachedSdk(String apiKey) {
        File sdkFile = this.getCachedSdkFile(apiKey);
        return sdkFile.exists() ? new FileBasedSDK(sdkFile) : new EmptySDK();
    }

    private File getCachedSdkFile(String apiKey) {
        return new File(this._sdksDir, apiKey + File.separator + "crashlytics.jar");
    }

    private void fireNewReleaseNotesAvailable() {
        for (SDKManagerListener listener : this.listeners) {
            listener.onNewReleaseNotesAvailable();
        }
    }

    @Override
    public void addSDKManagerListener(SDKManagerListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeSDKManagerListener(SDKManagerListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }
}

