/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android;

import com.crashlytics.api.RestfulWebApi;
import com.crashlytics.api.WebApi;
import com.crashlytics.tools.android.project.AndroidProject;
import com.crashlytics.tools.android.project.AndroidProjectStructure;
import com.crashlytics.tools.android.project.DataDirDeobsManager;
import com.crashlytics.tools.android.project.DefaultAndroidBuildHandler;
import com.crashlytics.tools.android.project.DeobsUploader;
import com.crashlytics.tools.android.project.DistributionUploader;
import com.crashlytics.tools.android.project.ResourceUpdateData;
import com.crashlytics.tools.android.project.StandardAndroidProject;
import com.crashlytics.tools.android.project.XmlBuildIdManager;
import com.crashlytics.tools.utils.PropertiesUtils;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.log4j.PropertyConfigurator;

public class DeveloperTools {
    public static final String CRASHLYTICS_JAR = "crashlytics.jar";
    public static final File CRASHLYTICS_DATA_ROOT = DeveloperTools.getAppDataFolder();
    public static final String DEVELOPER_TOOLS_ROOT = "com.crashlytics.tools";
    public static final File CRASHLYTICS_PROJECTS_ROOT = new File(CRASHLYTICS_DATA_ROOT, "com.crashlytics.tools");
    private static final String CRASHLYTICS_FAILED_DEOBS_UPLOAD_REASON = "had a problem uploading the deobs file. Please check network connectivity and try again.";
    private static final String CRASHLYTICS_FAILED_DIST_UPLOAD_REASON = "had a problem uploading the distribution. Please check network connectivity and try again.";
    public static final String STANDARD_LOGGER = "log4j.standard.properties";
    public static final String COMMAND_LINE_LOGGER = "log4j.commandline.properties";
    private static Logger customLogger;
    private static final String BASE_API_URL_PROP = "crashlytics.webApiUrl";
    protected static final String OPT_HELP = "help";
    public static final String OPT_GENERATE_RESOURCE_FILE = "generateResourceFile";
    public static final String OPT_CLEANUP_RESOURCE_FILE = "cleanupResourceFile";
    public static final String OPT_NOTIFY_BUILD_EVENT = "buildEvent";
    public static final String OPT_STORE_DEOBS = "storeDeobs";
    protected static final String OPT_STORE_DEOBS_ARG = "file";
    public static final String OPT_UPLOAD_DIST = "uploadDist";
    protected static final String OPT_UPLOAD_DIST_ARG = "file";
    public static final String OPT_BUILD_SECRET = "apiSecret";
    protected static final String OPT_BUILD_SECRET_ARG = "key";
    public static final String OPT_OBFUSCATING = "obfuscating";
    public static final String OPT_OBFUSCATOR = "obfuscator";
    protected static final String OPT_OBFUSCATOR_ARG = "obfuscatorId";
    public static final String OPT_OBFUSCATOR_VERSION = "obVer";
    protected static final String OPT_OBFUSCATOR_VERSION_ARG = "obfuscatorVersion";
    public static final String OPT_UPLOAD_DEOBS = "uploadDeobs";
    public static final String OPT_PATH = "projectPath";
    protected static final String OPT_PATH_ARG = "path";
    public static final String DEFAULT_PATH = ".";
    public static final String OPT_MANIFEST_PATH = "androidManifest";
    protected static final String OPT_MANIFEST_PATH_ARG = "androidManifestPath";
    public static final String OPT_RES_PATH = "androidRes";
    protected static final String OPT_RES_PATH_ARG = "androidResPath";
    public static final String OPT_VERBOSE = "verbose";
    public static final String OPT_QUIET = "quiet";
    public static final String OPT_RESOURCE_CHECK = "resourceCheck";
    public static final String OPT_BUILD_EVENT = "buildEvent";
    public static final String OPT_TOOL_ID = "tool";
    public static final String OPT_TOOL_VERSION = "version";
    public static final String OPT_PROPERTIES_PATH = "properties";
    public static final String OPT_REQUIRE_UPLOAD_SUCCESS = "requireUploadSuccess";
    private static final String OPEN_SOURCE_API_KEY_PATTERN = "^0[0]*$";
    protected static final String MANIFEST_API_KEY = "com.crashlytics.ApiKey";
    public static final String TEST_API_KEY = "testkey";
    public static final String STRINGS_API_KEY = "@string/api_key";
    public static final String LOCAL_DATA_SUBDIR = ".data";
    private static final Pattern HEX_PATTERN;
    private static WebApi sharedWebApi;

    private static File getAppDataFolder() {
        String os = System.getProperty("os.name").toUpperCase();
        String dataFile = os.contains("MAC") ? "Library/Caches/com.crashlytics" : ".crashlytics";
        return new File(System.getProperty("user.home"), dataFile);
    }

    public static org.apache.log4j.Logger configureCrashlyticsLogger(File outputDirectory) {
        return DeveloperTools.configureCrashlyticsLogger(outputDirectory, STANDARD_LOGGER);
    }

    public static org.apache.log4j.Logger configureCrashlyticsLogger(File outputDirectory, String logConfigurationPath) {
        System.setProperty("crashlytics.logger.home", new File(outputDirectory.getAbsolutePath(), "crashlytics.log").getAbsolutePath());
        Properties l4jProps = new Properties();
        try {
            l4jProps.load(DeveloperTools.class.getClassLoader().getResourceAsStream(logConfigurationPath));
            PropertyConfigurator.configure(l4jProps);
        }
        catch (IOException e) {
            System.err.println("Logger properties could not be intialized.");
            e.printStackTrace(System.err);
        }
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger("com.crashlytics");
        return logger;
    }

    public static WebApi getWebApi() {
        return sharedWebApi;
    }

    public static void setWebApi(WebApi api) {
        if (!"https://api.crashlytics.com".equals(api.getBaseApiUrl())) {
            DeveloperTools.logW("Crashlytics API host: " + api.getBaseApiUrl(), null);
        }
        sharedWebApi = api;
    }

    public static void setLogger(Logger l) {
        customLogger = l;
    }

    public static void logD(String msg) {
        customLogger.logD(msg);
    }

    public static void logI(String msg) {
        customLogger.logI(msg);
    }

    public static void logW(String msg, Throwable t) {
        customLogger.logW(msg, t);
    }

    public static void logE(String msg, Throwable t) {
        customLogger.logE(msg, t);
    }

    public static void logStackW(String msg) {
        DeveloperTools.logW(msg + "\n" + DeveloperTools.currentStackAsString(3), null);
    }

    public static void logStackE(String msg) {
        DeveloperTools.logE(msg + "\n" + DeveloperTools.currentStackAsString(3), null);
    }

    private static StringBuffer currentStackAsString(int frameStartIndex) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        StringBuffer sb = new StringBuffer();
        for (int i = frameStartIndex; i < trace.length; ++i) {
            sb.append("\t" + trace[i] + "\n");
        }
        return sb;
    }

    public static boolean isValidApiKeyFormat(String probe) {
        if (probe == null) {
            return false;
        }
        if (probe.equals(TEST_API_KEY) || probe.equals(STRINGS_API_KEY)) {
            DeveloperTools.logD("ApiKey is " + probe);
            return true;
        }
        if (probe.length() == 40) {
            return HEX_PATTERN.matcher(probe).matches();
        }
        return false;
    }

    public static boolean isValidBuildSecretFormat(String probe) {
        if (probe == null) {
            return false;
        }
        if (probe.length() == 64) {
            return HEX_PATTERN.matcher(probe).matches();
        }
        return false;
    }

    public static void main(String[] args) {
        DeveloperTools.processArgs(args, COMMAND_LINE_LOGGER);
    }

    public static void processArgs(String[] args) {
        DeveloperTools.processArgs(args, STANDARD_LOGGER);
    }

    private static void processArgs(String[] args, String loggerPath) {
        org.apache.log4j.Logger l4jLogger = DeveloperTools.configureCrashlyticsLogger(CRASHLYTICS_PROJECTS_ROOT, loggerPath);
        DeveloperTools.setLogger(new L4JWrappedLogger(l4jLogger));
        try {
            Options options = DeveloperTools.createOptions();
            GnuParser parser = new GnuParser();
            CommandLine line = parser.parse(options, args);
            if (line.hasOption(OPT_HELP)) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp(DeveloperTools.class.getName().toString(), options);
                return;
            }
            String baseApiUrl = System.getProperty(BASE_API_URL_PROP, "https://api.crashlytics.com");
            DeveloperTools.setWebApi(new RestfulWebApi(baseApiUrl));
            Properties properties = DeveloperTools.getProperties(line);
            DeveloperTools.processProperties(properties);
        }
        catch (PluginException ex) {
            throw ex;
        }
        catch (Exception e) {
            DeveloperTools.logE("Crashlytics Developer Tools error.", e);
            HelpFormatter formatter = new HelpFormatter();
            Options options = DeveloperTools.createOptions();
            formatter.printHelp(DeveloperTools.class.getName().toString(), options);
            System.exit(-1);
        }
    }

    private static Properties getProperties(CommandLine line) throws Exception {
        Properties propertiesFromDisk = new Properties();
        File propertiesFile = null;
        if (line.hasOption(OPT_PROPERTIES_PATH)) {
            propertiesFile = new File(line.getOptionValue(OPT_PROPERTIES_PATH));
            try {
                propertiesFromDisk = PropertiesUtils.read(propertiesFile);
            }
            catch (IOException io) {
                throw new IOException("Crashlytics could not load the specified properties file: " + propertiesFile);
            }
        }
        Properties optionsProperties = new Properties();
        for (Option opt : line.getOptions()) {
            if (opt.getValue() != null) {
                optionsProperties.put(opt.getOpt(), opt.getValue());
                continue;
            }
            optionsProperties.put(opt.getOpt(), "true");
        }
        propertiesFromDisk.putAll((Map<?, ?>)optionsProperties);
        return propertiesFromDisk;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void processProperties(Properties properties) throws Exception {
        Object uploader;
        String apiKey;
        DefaultAndroidBuildHandler buildHandler;
        String buildSecret;
        block29: {
            DeveloperTools.logD("Invoked Crashlytics Developer Tools with arguments: " + PropertiesUtils.toString(properties));
            if (!(properties.containsKey(OPT_GENERATE_RESOURCE_FILE) || properties.containsKey(OPT_CLEANUP_RESOURCE_FILE) || properties.containsKey(OPT_STORE_DEOBS) || properties.containsKey(OPT_UPLOAD_DEOBS) || properties.containsKey(OPT_UPLOAD_DIST))) {
                throw new IllegalArgumentException("Required argument(s) missing.");
            }
            if (properties.containsKey(OPT_TOOL_ID)) {
                sharedWebApi.setToolId(properties.getProperty(OPT_TOOL_ID));
                if (properties.containsKey(OPT_TOOL_VERSION)) {
                    sharedWebApi.setToolVersion(properties.getProperty(OPT_TOOL_VERSION));
                }
            } else {
                sharedWebApi.setToolId(DEVELOPER_TOOLS_ROOT);
                sharedWebApi.setToolVersion(DeveloperTools.class.getPackage().getImplementationVersion());
            }
            sharedWebApi.setOperatingSystem(System.getProperty("os.name"));
            buildSecret = properties.getProperty(OPT_BUILD_SECRET);
            File projectPath = new File(properties.getProperty(OPT_PATH, DEFAULT_PATH));
            File manifestPath = properties.containsKey(OPT_MANIFEST_PATH) ? new File(properties.getProperty(OPT_MANIFEST_PATH)) : new File(projectPath, "AndroidManifest.xml");
            File resPath = properties.containsKey(OPT_RES_PATH) ? new File(properties.getProperty(OPT_RES_PATH)) : new File(projectPath, "res");
            File propertiesFile = StandardAndroidProject.getPropertiesLoc(projectPath);
            if (properties.containsKey(OPT_PROPERTIES_PATH)) {
                propertiesFile = new File(properties.getProperty(OPT_PROPERTIES_PATH));
            }
            AndroidProjectStructure structure = new AndroidProjectStructure(projectPath, manifestPath, resPath, StandardAndroidProject.getDataDirectory(projectPath), propertiesFile);
            AndroidProject project = StandardAndroidProject.createDefaultProject(structure, buildSecret);
            DataDirDeobsManager deobsManager = new DataDirDeobsManager(project, XmlBuildIdManager.createManager(project.getResourceFile()));
            buildHandler = new DefaultAndroidBuildHandler(project);
            apiKey = project.getApiKey();
            String packageName = project.getManifestData().getPackageName();
            if (apiKey != null && apiKey.matches(OPEN_SOURCE_API_KEY_PATTERN)) {
                DeveloperTools.logD("Crashlytics API key is empty. To enable real-time crash reporting with Crashlytics, visit http://www.crashlytics.com.");
                return;
            }
            if (apiKey == null || !DeveloperTools.isValidApiKeyFormat(apiKey)) {
                throw new IllegalArgumentException("Invalid API key: " + apiKey + ". Check the Crashlytics plugin to make sure that the application has been added successfully! Contact support@crashlytics.com for assistance.");
            }
            DeveloperTools.logD("apiKey is " + apiKey);
            boolean buildSecretRequired = properties.containsKey(OPT_UPLOAD_DIST);
            if (buildSecret == null && buildSecretRequired || buildSecret != null && !DeveloperTools.isValidBuildSecretFormat(buildSecret)) {
                throw new IllegalArgumentException("Invalid secret API key: " + buildSecret + ". Check the Crashlytics plugin to make sure that the application has been added successfully! Contact support@crashlytics.com for assistance.");
            }
            if (properties.containsKey(OPT_RESOURCE_CHECK)) {
                DeveloperTools.logD("Checking for Resource");
                File resourceFile = project.getResourceFile();
                if (!resourceFile.exists()) {
                    String failMessage = packageName != null ? "Your team has updated " + packageName + " to include real-time crash reporting with Crashlytics.\n" + "Confirm you're part of this team and set up Android Studio here:\n" + "https://crashlytics.com/register/" + apiKey + "/android/" + packageName : "Your team has updated this project to include real-time crash reporting with Crashlytics.\nConfirm you're part of this team and set up Android Studio here:\nhttps://crashlytics.com";
                    DeveloperTools.logD(failMessage);
                    throw new PluginException(failMessage);
                }
            }
            if (properties.containsKey(OPT_GENERATE_RESOURCE_FILE)) {
                DeveloperTools.logD("Generating Crashlytics Resources");
                ResourceUpdateData updatedResources = buildHandler.updateBuildResources();
                DeveloperTools.logD("Set build id to " + updatedResources.getBuildId());
            }
            if (properties.containsKey(OPT_CLEANUP_RESOURCE_FILE)) {
                DeveloperTools.logD("Cleaning Crashlytics Resources");
                buildHandler.cleanBuildResources();
            }
            if (properties.containsKey(OPT_OBFUSCATING) && properties.containsKey(OPT_STORE_DEOBS)) {
                DeveloperTools.logD("Caching deobfuscation file");
                File deobsFile = new File(properties.getProperty(OPT_STORE_DEOBS));
                if (!properties.containsKey(OPT_OBFUSCATOR) || !properties.containsKey(OPT_OBFUSCATOR_VERSION)) {
                    throw new IllegalArgumentException("storeDeobs requires obfuscator and obVer");
                }
                if (deobsFile.exists()) {
                    String obfuscator = properties.getProperty(OPT_OBFUSCATOR);
                    String obfuscatorVer = properties.getProperty(OPT_OBFUSCATOR_VERSION);
                    DeveloperTools.logD("Saving deobfuscation file: " + deobsFile);
                    deobsManager.storeDeobfuscationFile(deobsFile, obfuscator, obfuscatorVer);
                } else {
                    DeveloperTools.logD("Crashlytics detected deobfuscation, but did not find a mapping file at " + deobsFile);
                }
            }
            if (properties.containsKey(OPT_UPLOAD_DEOBS)) {
                DeveloperTools.logD("Uploading deobfuscation file");
                boolean hasFiles = deobsManager.hasCachedDeobfuscationFiles();
                uploader = new DeobsUploader(DeveloperTools.getWebApi());
                if (hasFiles) {
                    boolean requireSuccess = properties.containsKey(OPT_REQUIRE_UPLOAD_SUCCESS);
                    try {
                        boolean result = ((DeobsUploader)uploader).uploadDeobfuscationFiles(deobsManager, apiKey);
                        if (result) {
                            DeveloperTools.logD("Deobfuscation file(s) uploaded.");
                            break block29;
                        } else {
                            DeveloperTools.logW("Crashlytics had a problem uploading the deobs file. Please check network connectivity and try again...", null);
                            if (requireSuccess) {
                                throw new PluginException("Crashlytics halted compilation because it had a problem uploading the deobs file. Please check network connectivity and try again...");
                            }
                        }
                        break block29;
                    }
                    catch (Exception e) {
                        DeveloperTools.logW("Crashlytics had a problem uploading the deobs file. Please check network connectivity and try again.", e);
                        if (requireSuccess) {
                            throw new PluginException("Crashlytics halted compilation because it had a problem uploading the deobs file. Please check network connectivity and try again.", e);
                        }
                        break block29;
                    }
                }
                DeveloperTools.logD("Crashlytics found no deobfuscation files.");
            }
        }
        if (properties.containsKey(OPT_UPLOAD_DIST)) {
            String path = properties.getProperty(OPT_UPLOAD_DIST);
            DeveloperTools.logD("Uploading distribution at" + path);
            uploader = new DistributionUploader(DeveloperTools.getWebApi());
            try {
                boolean result = ((DistributionUploader)uploader).uploadDistribution(path, apiKey, buildSecret);
                if (!result) {
                    DeveloperTools.logW("Crashlytics had a problem uploading the distribution. Please check network connectivity and try again...", null);
                    throw new PluginException("Crashlytics halted compilation because it had a problem uploading the distribution. Please check network connectivity and try again...");
                }
                DeveloperTools.logD("Distribution uploaded.");
            }
            catch (Exception e) {
                DeveloperTools.logW("Crashlytics had a problem uploading the distribution. Please check network connectivity and try again.", e);
                throw new PluginException("Crashlytics halted compilation because it had a problem uploading the distribution. Please check network connectivity and try again.", e);
            }
        }
        if (properties.containsKey("buildEvent")) {
            buildHandler.notifyBuildEvent();
        }
    }

    protected static Options createOptions() {
        Options options = new Options();
        Option buildId = new Option(OPT_GENERATE_RESOURCE_FILE, "Generate Crashlytics-required resources for the project.");
        Option deleteStrings = new Option(OPT_CLEANUP_RESOURCE_FILE, "Remove Crashlytics-generated resource files");
        OptionBuilder.withArgName("file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Store the specified deobfuscation file in preparation for upload.");
        Option saveDeobs = OptionBuilder.create(OPT_STORE_DEOBS);
        Option obfuscating = new Option(OPT_OBFUSCATING, "This build included obfuscation.");
        OptionBuilder.withArgName(OPT_OBFUSCATOR_ARG);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Optionally specify an obfuscator vendor identifier for use with storeDeobs.");
        Option obfuscatorId = OptionBuilder.create(OPT_OBFUSCATOR);
        OptionBuilder.withArgName(OPT_OBFUSCATOR_VERSION_ARG);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Optionally specify the obfuscator vendor software version for use with obfuscator.");
        Option obfuscatorVer = OptionBuilder.create(OPT_OBFUSCATOR_VERSION);
        Option uploadDeobs = new Option(OPT_UPLOAD_DEOBS, "Attempt to upload deobfuscation file(s) to Crashlytics servers.");
        OptionBuilder.withArgName("file");
        OptionBuilder.hasArg();
        Option uploadDist = OptionBuilder.create(OPT_UPLOAD_DIST);
        OptionBuilder.withArgName(OPT_PATH_ARG);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Path to Android project root");
        Option projectPath = OptionBuilder.create(OPT_PATH);
        OptionBuilder.withArgName(OPT_MANIFEST_PATH_ARG);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Path to AndroidManifest.xml)");
        Option manifestPath = OptionBuilder.create(OPT_MANIFEST_PATH);
        OptionBuilder.withArgName(OPT_RES_PATH_ARG);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Path to Android resources (res/ folder)");
        Option resPath = OptionBuilder.create(OPT_RES_PATH);
        OptionBuilder.withArgName(OPT_BUILD_SECRET_ARG);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("API Secret for the project");
        Option buildSecret = OptionBuilder.create(OPT_BUILD_SECRET);
        Option verbose = new Option(OPT_VERBOSE, "Verbose command line output");
        Option quiet = new Option(OPT_QUIET, "Silent command line output");
        Option help = new Option(OPT_HELP, "Display command help.");
        Option check = new Option(OPT_RESOURCE_CHECK, "Check if a resource file already exists.");
        OptionBuilder.withArgName("toolarg");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Name of the build tool");
        Option toolName = OptionBuilder.create(OPT_TOOL_ID);
        OptionBuilder.withArgName("versionarg");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Version of the build tool");
        Option toolVersion = OptionBuilder.create(OPT_TOOL_VERSION);
        OptionBuilder.withArgName("propertiesarg");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Properties file that overrides the input properties");
        Option propertiesPath = OptionBuilder.create(OPT_PROPERTIES_PATH);
        Option buildEvent = new Option("buildEvent", "Notify Crashlytics that a build event has occurred");
        Option requireUploadSuccess = new Option(OPT_REQUIRE_UPLOAD_SUCCESS, "Throw an exception if the deobfuscation upload was not successful");
        options.addOption(buildId);
        options.addOption(deleteStrings);
        options.addOption(saveDeobs);
        options.addOption(obfuscating);
        options.addOption(obfuscatorId);
        options.addOption(obfuscatorVer);
        options.addOption(uploadDeobs);
        options.addOption(uploadDist);
        options.addOption(projectPath);
        options.addOption(manifestPath);
        options.addOption(quiet);
        options.addOption(resPath);
        options.addOption(buildSecret);
        options.addOption(verbose);
        options.addOption(help);
        options.addOption(check);
        options.addOption(requireUploadSuccess);
        options.addOption(toolName);
        options.addOption(toolVersion);
        options.addOption(buildEvent);
        options.addOption(propertiesPath);
        return options;
    }

    static {
        if (CRASHLYTICS_DATA_ROOT.isFile()) {
            throw new RuntimeException("Crashlytics data directory at " + CRASHLYTICS_DATA_ROOT.getAbsolutePath() + " is not a directory");
        }
        if (!CRASHLYTICS_DATA_ROOT.exists() && !CRASHLYTICS_DATA_ROOT.mkdir()) {
            throw new RuntimeException("Crashlytics data directory at " + CRASHLYTICS_DATA_ROOT.getAbsolutePath() + " could not be created.");
        }
        customLogger = new StdOutLogger();
        HEX_PATTERN = Pattern.compile("[0-9a-f]+");
    }

    public static class StdOutLogger
    implements Logger {
        @Override
        public synchronized void logD(String msg) {
            System.out.println("[CLSLOG DEBUG] " + msg);
        }

        @Override
        public synchronized void logI(String msg) {
            System.out.println("[CLSLOG INFO] " + msg);
        }

        @Override
        public synchronized void logW(String msg, Throwable t) {
            System.out.println("[CLSLOG WARN] " + msg);
            if (t != null) {
                System.err.println(t);
                t.printStackTrace();
            }
        }

        @Override
        public synchronized void logE(String msg, Throwable t) {
            System.err.println("[CLSLOG ERR] " + msg);
            if (t != null) {
                System.err.println(t);
                t.printStackTrace();
            }
        }
    }

    public static class L4JWrappedLogger
    implements Logger {
        private final org.apache.log4j.Logger _logger;

        public L4JWrappedLogger(org.apache.log4j.Logger logger) {
            this._logger = logger;
        }

        @Override
        public synchronized void logD(String msg) {
            this._logger.debug(msg);
        }

        @Override
        public synchronized void logI(String msg) {
            this._logger.info(msg);
        }

        @Override
        public synchronized void logW(String msg, Throwable t) {
            this._logger.warn(msg, t);
        }

        @Override
        public synchronized void logE(String msg, Throwable t) {
            this._logger.error(msg, t);
        }
    }

    public static class MultiLogger
    implements Logger {
        private final Logger[] _loggers;

        public MultiLogger(Logger ... loggers) {
            this._loggers = loggers;
        }

        @Override
        public synchronized void logD(String msg) {
            for (Logger l : this._loggers) {
                l.logD(msg);
            }
        }

        @Override
        public synchronized void logI(String msg) {
            for (Logger l : this._loggers) {
                l.logI(msg);
            }
        }

        @Override
        public synchronized void logW(String msg, Throwable t) {
            for (Logger l : this._loggers) {
                l.logW(msg, t);
            }
        }

        @Override
        public synchronized void logE(String msg, Throwable t) {
            for (Logger l : this._loggers) {
                l.logE(msg, t);
            }
        }
    }

    public static interface Logger {
        public void logD(String var1);

        public void logI(String var1);

        public void logW(String var1, Throwable var2);

        public void logE(String var1, Throwable var2);
    }

    public static class PluginException
    extends RuntimeException {
        public PluginException(String message) {
            super(message);
        }

        public PluginException(String message, Exception parent) {
            super(message, parent);
        }
    }
}

