/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project;

import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.project.AndroidBuildHandler;
import com.crashlytics.tools.android.project.AndroidProject;
import com.crashlytics.tools.android.project.BuildIdManager;
import com.crashlytics.tools.android.project.BuildSecretMaintainer;
import com.crashlytics.tools.android.project.ResourceUpdateData;
import com.crashlytics.tools.android.project.XmlBuildIdManager;
import java.io.IOException;

public class DefaultAndroidBuildHandler
implements AndroidBuildHandler {
    protected final AndroidProject _project;
    private final BuildIdManager _buildIdManager;
    private final BuildSecretMaintainer _buildSecretMaintainer;

    public DefaultAndroidBuildHandler(AndroidProject androidProject) {
        this(androidProject, XmlBuildIdManager.createManager(androidProject.getResourceFile()), new BuildSecretMaintainer(androidProject.getBuildSecret(), androidProject.getPropertiesPath()));
    }

    public DefaultAndroidBuildHandler(AndroidProject project, BuildIdManager buildIdManager, BuildSecretMaintainer buildSecretMaintainer) {
        this._project = project;
        this._buildIdManager = buildIdManager;
        this._buildSecretMaintainer = buildSecretMaintainer;
    }

    @Override
    public ResourceUpdateData updateBuildResources() throws IOException {
        ResourceUpdateData resourceUpdate = new ResourceUpdateData(this._buildIdManager.updateBuildId());
        return resourceUpdate;
    }

    @Override
    public void cleanBuildResources() {
        this._buildIdManager.removeBuildId();
    }

    @Override
    public void notifyBuildEvent() {
        try {
            DeveloperTools.getWebApi().asyncNotifyBuildEvent(this._project.getManifestData().getPackage(), this._buildIdManager.getBuildId().toString(), this._project.getApiKey(), this._project.getBuildSecret());
        }
        catch (Exception e) {
            DeveloperTools.logD("Crashlytics was unable to note a build event");
        }
    }
}

