/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project;

import com.crashlytics.api.AuthenticationException;
import com.crashlytics.api.Organization;
import com.crashlytics.api.WebApi;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.project.AndroidProject;
import com.crashlytics.tools.android.project.AndroidProjectStructure;
import com.crashlytics.tools.android.project.DefaultManifestData;
import com.crashlytics.tools.android.project.ManifestData;
import com.crashlytics.tools.utils.FileUtils;
import java.io.File;
import java.io.IOException;

public class StandardAndroidProject
implements AndroidProject {
    private static final String STANDARD_TYPE = "STANDARD_PROJECT";
    private final File _dataPath;
    private final ManifestData _manifestData;
    private final File _manifestFile;
    private final File _rootPath;
    private final File _propertyFilePath;
    private final File _resourceFile;
    private final String _projectType;
    private final String _buildSecret;
    private boolean hasVerified = false;

    public static File getPropertiesLoc(File projLoc) {
        return new File(projLoc, "crashlytics.properties");
    }

    public static File getDataDirectory(File projectRootDirectory) {
        return new File(DeveloperTools.CRASHLYTICS_PROJECTS_ROOT, FileUtils.getIdentifier(projectRootDirectory));
    }

    public static File getStringResourceLoc(File projectResDirectory) {
        if (!projectResDirectory.isDirectory()) {
            throw new IllegalArgumentException("Invalid resource path: " + projectResDirectory.getAbsolutePath());
        }
        File valuesPath = new File(projectResDirectory, "values");
        File resourceFile = new File(valuesPath, "com_crashlytics_export_strings.xml");
        return resourceFile;
    }

    public static AndroidProject createDefaultProject(AndroidProjectStructure structure, String buildSecret) throws IOException {
        return StandardAndroidProject.createTypedProject(structure, buildSecret, STANDARD_TYPE);
    }

    public static StandardAndroidProject createTypedProject(AndroidProjectStructure structure, String buildSecret, String projectType) throws IOException {
        File projectPath = structure.getProjectRootDir();
        if (!projectPath.exists() || !projectPath.isDirectory()) {
            throw new IllegalArgumentException("Project path is not a directory: " + projectPath);
        }
        File manifestFile = structure.getManifestFile();
        File dataPath = structure.getProjectDataPath();
        File resDir = structure.getResourceDir();
        File resourceFile = StandardAndroidProject.getStringResourceLoc(resDir);
        DefaultManifestData manifestData = DefaultManifestData.createManifest(structure.getManifestFile());
        if (!projectPath.exists() || !projectPath.isDirectory()) {
            throw new IllegalArgumentException("Project path is not a directory: " + projectPath);
        }
        if (buildSecret == null) {
            try {
                Organization org;
                WebApi api = DeveloperTools.getWebApi();
                if (api != null && (org = api.getOrg(manifestData.getMetaData().get("com.crashlytics.ApiKey"))) != null) {
                    buildSecret = org.getBuildSecret();
                }
            }
            catch (AuthenticationException e) {
                // empty catch block
            }
        }
        return new StandardAndroidProject(projectPath, manifestFile, dataPath, structure.getPropertyFile(), resourceFile, manifestData, projectType, buildSecret);
    }

    public StandardAndroidProject(File projectPath, File manifestFile, File projectDataPath, File propertyFilePath, File resourceFile, ManifestData manifestData, String projectType, String buildSecret) {
        this._manifestFile = manifestFile;
        this._manifestData = manifestData;
        this._dataPath = projectDataPath;
        this._rootPath = projectPath;
        this._propertyFilePath = propertyFilePath;
        this._resourceFile = resourceFile;
        this._projectType = projectType;
        this._buildSecret = buildSecret;
    }

    protected synchronized void createDataDir() throws IOException {
        FileUtils.verifyDirectory(this._dataPath);
    }

    @Override
    public File getManifestFile() {
        return this._manifestFile;
    }

    @Override
    public ManifestData getManifestData() {
        return this._manifestData;
    }

    @Override
    public File getLauncherIcon() {
        return this._manifestData.getLauncherIcon();
    }

    @Override
    public File getDataDirectory() {
        if (!this.hasVerified) {
            try {
                FileUtils.verifyDirectory(this._dataPath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.hasVerified = true;
        }
        return this._dataPath;
    }

    @Override
    public File getResourceFile() {
        return this._resourceFile;
    }

    @Override
    public File getRootPath() {
        return this._rootPath;
    }

    @Override
    public String getApiKey() {
        return this.getManifestData().getMetaData().get("com.crashlytics.ApiKey");
    }

    @Override
    public File getPropertiesPath() {
        return this._propertyFilePath;
    }

    @Override
    public String getProjectType() {
        return this._projectType;
    }

    @Override
    public String getBuildSecret() {
        return this._buildSecret;
    }
}

