/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.project;

import com.android.io.FolderWrapper;
import com.android.io.IAbstractFile;
import com.android.io.IAbstractFolder;
import com.android.io.StreamException;
import com.android.sdklib.ISdkLog;
import com.android.sdklib.internal.project.ProjectPropertiesWorkingCopy;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectProperties {
    protected static final Pattern PATTERN_PROP = Pattern.compile("^([a-zA-Z0-9._-]+)\\s*=\\s*(.*)\\s*$");
    public static final String PROPERTY_TARGET = "target";
    public static final String PROPERTY_LIBRARY = "android.library";
    public static final String PROPERTY_LIB_REF = "android.library.reference.";
    private static final String PROPERTY_LIB_REF_REGEX = "android.library.reference.\\d+";
    public static final String PROPERTY_PROGUARD_CONFIG = "proguard.config";
    public static final String PROPERTY_RULES_PATH = "layoutrules.jars";
    public static final String PROPERTY_SDK = "sdk.dir";
    private static final String PROPERTY_SDK_LEGACY = "sdk-location";
    public static final String PROPERTY_SPLIT_BY_DENSITY = "split.density";
    public static final String PROPERTY_SPLIT_BY_ABI = "split.abi";
    public static final String PROPERTY_SPLIT_BY_LOCALE = "split.locale";
    public static final String PROPERTY_TESTED_PROJECT = "tested.project.dir";
    public static final String PROPERTY_BUILD_SOURCE_DIR = "source.dir";
    public static final String PROPERTY_BUILD_OUT_DIR = "out.dir";
    public static final String PROPERTY_PACKAGE = "package";
    public static final String PROPERTY_VERSIONCODE = "versionCode";
    public static final String PROPERTY_PROJECTS = "projects";
    public static final String PROPERTY_KEY_STORE = "key.store";
    public static final String PROPERTY_KEY_ALIAS = "key.alias";
    private static final String LOCAL_HEADER = "# This file is automatically generated by Android Tools.\n# Do not modify this file -- YOUR CHANGES WILL BE ERASED!\n#\n# This file must *NOT* be checked into Version Control Systems,\n# as it contains information specific to your local configuration.\n\n";
    private static final String DEFAULT_HEADER = "# This file is automatically generated by Android Tools.\n# Do not modify this file -- YOUR CHANGES WILL BE ERASED!\n#\n# This file must be checked in Version Control Systems.\n#\n# To customize properties used by the Ant build system edit\n# \"ant.properties\", and override values to adapt the script to your\n# project structure.\n#\n# To enable ProGuard to shrink and obfuscate your code, uncomment this (available properties: sdk.dir, user.home):\n#proguard.config=${sdk.dir}" + File.separator + "tools" + File.separator + "proguard" + File.separator + "proguard-android.txt" + ':' + "proguard-project.txt" + '\n' + "\n";
    private static final String BUILD_HEADER = "# This file is used to override default values used by the Ant build system.\n#\n# This file must be checked into Version Control Systems, as it is\n# integral to the build system of your project.\n\n# This file is only used by the Ant script.\n\n# You can use this to override default values such as\n#  'source.dir' for the location of your java source folder and\n#  'out.dir' for the location of your output folder.\n\n# You can also use it define how the release builds are signed by declaring\n# the following properties:\n#  'key.store' for the location of your keystore and\n#  'key.alias' for the name of the key to use.\n# The password will be asked during the build when you use the 'release' target.\n\n";
    protected final IAbstractFolder mProjectFolder;
    protected final Map<String, String> mProperties;
    protected final PropertyType mType;

    public static ProjectProperties load(String string, PropertyType propertyType) {
        FolderWrapper folderWrapper = new FolderWrapper(string);
        return ProjectProperties.load(folderWrapper, propertyType);
    }

    public static ProjectProperties load(IAbstractFolder iAbstractFolder, PropertyType propertyType) {
        Map<String, String> map;
        IAbstractFile iAbstractFile;
        if (iAbstractFolder.exists() && (iAbstractFile = iAbstractFolder.getFile(propertyType.mFilename)).exists() && (map = ProjectProperties.parsePropertyFile(iAbstractFile, null)) != null) {
            return new ProjectProperties(iAbstractFolder, map, propertyType);
        }
        return null;
    }

    public static boolean delete(IAbstractFolder iAbstractFolder, PropertyType propertyType) {
        IAbstractFile iAbstractFile;
        if (iAbstractFolder.exists() && (iAbstractFile = iAbstractFolder.getFile(propertyType.mFilename)).exists()) {
            return iAbstractFile.delete();
        }
        return false;
    }

    public static boolean delete(String string, PropertyType propertyType) {
        FolderWrapper folderWrapper = new FolderWrapper(string);
        return ProjectProperties.delete(folderWrapper, propertyType);
    }

    public static ProjectPropertiesWorkingCopy create(String string, PropertyType propertyType) {
        FolderWrapper folderWrapper = new FolderWrapper(string);
        return ProjectProperties.create(folderWrapper, propertyType);
    }

    public static ProjectPropertiesWorkingCopy create(IAbstractFolder iAbstractFolder, PropertyType propertyType) {
        return new ProjectPropertiesWorkingCopy(iAbstractFolder, new HashMap<String, String>(), propertyType);
    }

    public ProjectPropertiesWorkingCopy makeWorkingCopy() {
        return this.makeWorkingCopy(this.mType);
    }

    public ProjectPropertiesWorkingCopy makeWorkingCopy(PropertyType propertyType) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.putAll(this.mProperties);
        return new ProjectPropertiesWorkingCopy(this.mProjectFolder, hashMap, propertyType);
    }

    public PropertyType getType() {
        return this.mType;
    }

    public synchronized String getProperty(String string) {
        return this.mProperties.get(string);
    }

    public synchronized Set<String> keySet() {
        return new HashSet<String>(this.mProperties.keySet());
    }

    public synchronized void reload() {
        Map<String, String> map;
        IAbstractFile iAbstractFile;
        if (this.mProjectFolder.exists() && (iAbstractFile = this.mProjectFolder.getFile(this.mType.mFilename)).exists() && (map = ProjectProperties.parsePropertyFile(iAbstractFile, null)) != null) {
            this.mProperties.clear();
            this.mProperties.putAll(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> parsePropertyFile(IAbstractFile iAbstractFile, ISdkLog iSdkLog) {
        BufferedReader bufferedReader = null;
        try {
            Object object;
            bufferedReader = new BufferedReader(new InputStreamReader(iAbstractFile.getContents(), "UTF-8"));
            String string = null;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            while ((string = bufferedReader.readLine()) != null) {
                if (string.length() <= 0 || string.charAt(0) == '#') continue;
                object = PATTERN_PROP.matcher(string);
                if (!((Matcher)object).matches()) {
                    iSdkLog.warning("Error parsing '%1$s': \"%2$s\" is not a valid syntax", iAbstractFile.getOsLocation(), string);
                    Map<String, String> map = null;
                    return map;
                }
                hashMap.put(((Matcher)object).group(1), ((Matcher)object).group(2));
            }
            object = hashMap;
            return object;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            iSdkLog.warning("Error parsing '%1$s': %2$s.", iAbstractFile.getOsLocation(), iOException.getMessage());
        }
        catch (StreamException streamException) {
            iSdkLog.warning("Error parsing '%1$s': %2$s.", iAbstractFile.getOsLocation(), streamException.getMessage());
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    protected ProjectProperties(IAbstractFolder iAbstractFolder, Map<String, String> map, PropertyType propertyType) {
        this.mProjectFolder = iAbstractFolder;
        this.mProperties = map;
        this.mType = propertyType;
    }

    static /* synthetic */ String access$000() {
        return DEFAULT_HEADER;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PropertyType {
        ANT("ant.properties", "# This file is used to override default values used by the Ant build system.\n#\n# This file must be checked into Version Control Systems, as it is\n# integral to the build system of your project.\n\n# This file is only used by the Ant script.\n\n# You can use this to override default values such as\n#  'source.dir' for the location of your java source folder and\n#  'out.dir' for the location of your output folder.\n\n# You can also use it define how the release builds are signed by declaring\n# the following properties:\n#  'key.store' for the location of your keystore and\n#  'key.alias' for the name of the key to use.\n# The password will be asked during the build when you use the 'release' target.\n\n", new String[]{"source.dir", "out.dir"}, null),
        PROJECT("project.properties", ProjectProperties.access$000(), new String[]{"target", "android.library", "android.library.reference.\\d+", "key.store", "key.alias", "proguard.config", "layoutrules.jars"}, null),
        LOCAL("local.properties", "# This file is automatically generated by Android Tools.\n# Do not modify this file -- YOUR CHANGES WILL BE ERASED!\n#\n# This file must *NOT* be checked into Version Control Systems,\n# as it contains information specific to your local configuration.\n\n", new String[]{"sdk.dir"}, new String[]{"sdk-location"}),
        LEGACY_DEFAULT("default.properties", null, null, null),
        LEGACY_BUILD("build.properties", null, null, null);

        private final String mFilename;
        private final String mHeader;
        private final Set<String> mKnownProps;
        private final Set<String> mRemovedProps;

        private PropertyType(String string2, String string3, String[] stringArray, String[] stringArray2) {
            this.mFilename = string2;
            this.mHeader = string3;
            HashSet<String> hashSet = new HashSet<String>();
            if (stringArray != null) {
                hashSet.addAll(Arrays.asList(stringArray));
            }
            this.mKnownProps = Collections.unmodifiableSet(hashSet);
            hashSet = new HashSet();
            if (stringArray2 != null) {
                hashSet.addAll(Arrays.asList(stringArray2));
            }
            this.mRemovedProps = Collections.unmodifiableSet(hashSet);
        }

        public String getFilename() {
            return this.mFilename;
        }

        public String getHeader() {
            return this.mHeader;
        }

        public boolean isKnownProperty(String string) {
            for (String string2 : this.mKnownProps) {
                if (!string2.equals(string) && !Pattern.matches(string2, string)) continue;
                return true;
            }
            return false;
        }

        public boolean isRemovedProperty(String string) {
            for (String string2 : this.mRemovedProps) {
                if (!string2.equals(string) && !Pattern.matches(string2, string)) continue;
                return true;
            }
            return false;
        }
    }
}

