/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository;

import com.android.sdklib.internal.repository.ILayoutlibVersion;
import com.android.sdklib.internal.repository.Package;
import com.android.sdklib.internal.repository.XmlParserUtils;
import com.android.util.Pair;
import java.util.Properties;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutlibVersionMixin
implements ILayoutlibVersion {
    private final Pair<Integer, Integer> mLayoutlibVersion;

    public LayoutlibVersionMixin(Node node) {
        int n = 0;
        int n2 = 0;
        Node node2 = XmlParserUtils.getFirstChild(node, "layoutlib");
        if (node2 != null) {
            n = XmlParserUtils.getXmlInt(node2, "api", 0);
            n2 = XmlParserUtils.getXmlInt(node2, "revision", 0);
        }
        this.mLayoutlibVersion = Pair.of(n, n2);
    }

    public LayoutlibVersionMixin(Properties properties) {
        int n = Integer.parseInt(Package.getProperty(properties, "Layoutlib.Api", Integer.toString(0)));
        int n2 = Integer.parseInt(Package.getProperty(properties, "Layoutlib.Revision", Integer.toString(0)));
        this.mLayoutlibVersion = Pair.of(n, n2);
    }

    void saveProperties(Properties properties) {
        if (this.mLayoutlibVersion.getFirst() != 0) {
            properties.setProperty("Layoutlib.Api", this.mLayoutlibVersion.getFirst().toString());
            properties.setProperty("Layoutlib.Revision", this.mLayoutlibVersion.getSecond().toString());
        }
    }

    @Override
    public Pair<Integer, Integer> getLayoutlibVersion() {
        return this.mLayoutlibVersion;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.mLayoutlibVersion == null ? 0 : this.mLayoutlibVersion.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof LayoutlibVersionMixin)) {
            return false;
        }
        LayoutlibVersionMixin layoutlibVersionMixin = (LayoutlibVersionMixin)object;
        return !(this.mLayoutlibVersion == null ? layoutlibVersionMixin.mLayoutlibVersion != null : !this.mLayoutlibVersion.equals(layoutlibVersionMixin.mLayoutlibVersion));
    }
}

