/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.api;

import com.crashlytics.api.App;
import org.json.simple.JSONObject;

public class Issue {
    private static final Long CRASH_EVENT = 1L;
    private static final Long NONFATAL_EVENT = 2L;
    public static String JSON_ISSUE_DISPLAY_ID = "display_id";
    public static String JSON_ISSUE_IMPACT_LEVEL = "impact_level";
    public static String JSON_ISSUE_TITLE = "title";
    public static String JSON_ISSUE_SUBTITLE = "subtitle";
    public static String JSON_ISSUE_CRASH_COUNT = "crashes_count";
    public static String JSON_ISSUE_IMPACTED_DEVICES_COUNT = "impacted_devices_count";
    public static String JSON_ISSUE_BUILD = "build";
    public static String JSON_ISSUE_URL = "url";
    public static String JSON_EVENT_TYPE = "event_type";
    private final App _application;
    private int _impactLevel;
    private final String _title;
    private String _subtitle;
    private int _count;
    private int _impactedDeviceCount;
    private final int _displayId;
    private final String _build;
    private final String _url;
    private String _shortSubTitle;
    private EventType _eventType;

    public Issue(App app, int impactLevel, String title, String subtitle, int count, int impactedDeviceCount, int displayId, String build, String url, EventType eventType) {
        this._application = app;
        this._impactLevel = impactLevel;
        this._title = title;
        this._subtitle = subtitle;
        this._count = count;
        this._impactedDeviceCount = impactedDeviceCount;
        this._displayId = displayId;
        this._build = build;
        this._url = url;
        this._eventType = eventType;
        this._shortSubTitle = this._subtitle.substring(subtitle.substring(0, Math.max(0, subtitle.lastIndexOf(46))).lastIndexOf(46) + 1);
    }

    public Issue(JSONObject json, App app) {
        this(app, ((Long)json.get(JSON_ISSUE_IMPACT_LEVEL)).intValue(), (String)json.get(JSON_ISSUE_TITLE), (String)json.get(JSON_ISSUE_SUBTITLE), ((Long)json.get(JSON_ISSUE_CRASH_COUNT)).intValue(), ((Long)json.get(JSON_ISSUE_IMPACTED_DEVICES_COUNT)).intValue(), ((Long)json.get(JSON_ISSUE_DISPLAY_ID)).intValue(), (String)json.get(JSON_ISSUE_BUILD), (String)json.get(JSON_ISSUE_URL), EventType.parseEventType((Long)json.get(Issue.JSON_EVENT_TYPE)));
    }

    public App getApplication() {
        return this._application;
    }

    public int getImpactLevel() {
        return this._impactLevel;
    }

    public void setImpactLevel(int impactLevel) {
        this._impactLevel = impactLevel;
    }

    public String getTitle() {
        return this._title;
    }

    public String getSubtitle() {
        return this._subtitle;
    }

    public String getShortSubtitle() {
        return this._shortSubTitle;
    }

    public void setSubtitle(String subtitle) {
        this._subtitle = subtitle;
    }

    public int getCount() {
        return this._count;
    }

    public void setCount(int count) {
        this._count = count;
    }

    public int getImpactedDeviceCount() {
        return this._impactedDeviceCount;
    }

    public void setImpactedDeviceCount(int impactedDeviceCount) {
        this._impactedDeviceCount = impactedDeviceCount;
    }

    public int getDisplayId() {
        return this._displayId;
    }

    public String getBuild() {
        return this._build;
    }

    public int getVersion() {
        String version = this._build.lastIndexOf(40) > -1 ? this._build.substring(this._build.lastIndexOf(40) + 1, this._build.lastIndexOf(41)) : "0";
        return Integer.parseInt(version);
    }

    public String getUrl() {
        return this._url;
    }

    public EventType getEventType() {
        return this._eventType;
    }

    public static enum EventType {
        CRASH,
        NONFATAL;


        private static EventType parseEventType(Long eventType) {
            EventType returnEventType = null;
            if (CRASH_EVENT == eventType) {
                returnEventType = CRASH;
            } else if (NONFATAL_EVENT == eventType) {
                returnEventType = NONFATAL;
            }
            return returnEventType;
        }
    }
}

