/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.api.ota;

import com.crashlytics.api.ota.Device;
import com.crashlytics.api.ota.PersonEvent;
import com.crashlytics.api.ota.PersonInvitation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class Person
implements Comparable<Person> {
    private static final String ACCEPTED = "accepted";
    private static final String ENABLED = "enabled";
    public final String testerId;
    public final String emailStatus;
    public final String invitationId;
    public final Date overallStatusModifiedAt;
    public final String email;
    public final List<PersonEvent> events;
    public final String name;
    public final String overallStatus;
    public final List<Device> devices;
    public final PersonInvitation invitation;
    public final String access;
    private boolean _selected;

    public Person(String email) {
        this(null, null, null, null, email, Collections.emptyList(), "", null, Collections.emptyList(), null, ENABLED);
    }

    public Person(String id, String emailStatus, String invitationId, Date overallStatusModifiedAt, String email, List<PersonEvent> events, String name, String overallStatus, List<Device> devices, PersonInvitation invitation, String access) {
        this.testerId = id;
        this.emailStatus = emailStatus;
        this.invitationId = invitationId;
        this.overallStatusModifiedAt = overallStatusModifiedAt;
        this.email = email;
        this.events = Collections.unmodifiableList(new ArrayList<PersonEvent>(events));
        this.name = name;
        this.overallStatus = overallStatus;
        this.devices = Collections.unmodifiableList(new ArrayList<Device>(devices));
        this.invitation = invitation;
        this.access = access;
        this._selected = this.isAccessEnabled();
    }

    public boolean isSelected() {
        return this._selected;
    }

    public void setSelected(boolean selected) {
        this._selected = selected;
    }

    public boolean isTester() {
        return this.testerId != null;
    }

    public boolean isInvitation() {
        return this.testerId == null && this.invitationId != null;
    }

    public boolean isAccessEnabled() {
        return ENABLED.equals(this.access);
    }

    public boolean isStatusAccepted() {
        return ACCEPTED.equals(this.overallStatus);
    }

    @Override
    public int compareTo(Person other) {
        String thisName = this.getNameForComparison();
        String otherName = other.getNameForComparison();
        if (thisName.isEmpty() && !otherName.isEmpty()) {
            return 1;
        }
        if (!thisName.isEmpty() && otherName.isEmpty()) {
            return -1;
        }
        int nameComparison = thisName.compareTo(otherName);
        if (nameComparison == 0) {
            return this.getEmailForComparison().compareTo(other.getEmailForComparison());
        }
        return nameComparison;
    }

    private String getNameForComparison() {
        return this.name == null ? "" : this.name.toLowerCase();
    }

    private String getEmailForComparison() {
        return this.email == null ? "" : this.email.toLowerCase();
    }
}

