/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.api.ota;

import com.crashlytics.api.ApiUtils;
import com.crashlytics.api.ota.Device;
import com.crashlytics.api.ota.Person;
import com.crashlytics.api.ota.PersonEvent;
import com.crashlytics.api.ota.PersonInvitation;
import com.crashlytics.api.ota.Release;
import com.crashlytics.api.ota.ReleaseSummariesJsonTransform;
import com.crashlytics.api.ota.ReleaseSummary;
import com.crashlytics.tools.utils.NumberUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ReleaseJsonTransform {
    private static final String SUMMARY = "summary";
    private static final String AUTHORIZED_DEVICES = "authorized_devices";
    private static final String ENTRIES = "entries";
    private static final String ID = "id";
    private static final String EMAIL_STATUS = "email_status";
    private static final String INVITATION_ID = "invitation_id";
    private static final String OVERALL_STATUS_MODIFIED_AT = "overall_status_modified_at";
    private static final String EMAIL = "email";
    private static final String EVENTS = "events";
    private static final String NAME = "name";
    private static final String OVERALL_STATUS = "overall_status";
    private static final String DEVICES = "devices";
    private static final String INVITATION = "invitation";
    private static final String ACCESS = "access";
    private static final String STATUS = "status";
    private static final String MODIFIED_AT = "modified_at";
    private static final String EVENT = "event";
    private static final String EVENT_AT = "event_at";
    private static final String BUILD_INSTANCE_ID = "build_instance_id";
    private final ReleaseSummariesJsonTransform releaseSummaryTransform = new ReleaseSummariesJsonTransform();

    public Release createReleaseFrom(JSONObject releaseJson) {
        if (releaseJson == null) {
            return null;
        }
        JSONObject summaryJson = (JSONObject)releaseJson.get(SUMMARY);
        ReleaseSummary summary = this.releaseSummaryTransform.createSingleReleaseSummaryFrom(summaryJson);
        JSONArray authorizedDevices = (JSONArray)releaseJson.get(AUTHORIZED_DEVICES);
        List<Person> people = this.createPeopleFrom(releaseJson);
        return new Release(summary, authorizedDevices, people);
    }

    public Release createAccessReleaseFrom(JSONObject releaseJson) {
        if (releaseJson == null) {
            return null;
        }
        JSONObject summaryJson = (JSONObject)releaseJson.get(SUMMARY);
        ReleaseSummary summary = this.releaseSummaryTransform.createAccessReleaseSummaryFrom(summaryJson);
        List<Person> entries = this.createPeopleFrom(releaseJson);
        return new Release(summary, Collections.<String>emptyList(), entries);
    }

    private List<Person> createPeopleFrom(JSONObject releaseJson) {
        ArrayList<Person> people = new ArrayList<Person>();
        JSONArray peopleJson = (JSONArray)releaseJson.get(ENTRIES);
        if (peopleJson != null) {
            for (Object personObj : peopleJson) {
                JSONObject personJson = (JSONObject)personObj;
                people.add(this.createPersonFrom(personJson));
            }
        }
        return people;
    }

    private Person createPersonFrom(JSONObject jsonObject) {
        String testerId = NumberUtils.toString((Long)jsonObject.get(ID));
        String emailStatus = (String)jsonObject.get(EMAIL_STATUS);
        String invitationId = NumberUtils.toString((Long)jsonObject.get(INVITATION_ID));
        Date overallStatusModifiedAt = ApiUtils.dateFromEpochSeconds((Long)jsonObject.get(OVERALL_STATUS_MODIFIED_AT));
        String email = (String)jsonObject.get(EMAIL);
        ArrayList<PersonEvent> events = new ArrayList<PersonEvent>();
        JSONArray eventsJson = (JSONArray)jsonObject.get(EVENTS);
        if (eventsJson != null) {
            for (Object obj : eventsJson) {
                JSONObject eventJson = (JSONObject)obj;
                events.add(this.createPersonEventFrom(eventJson));
            }
        }
        String name = (String)jsonObject.get(NAME);
        String overallStatus = (String)jsonObject.get(OVERALL_STATUS);
        String access = (String)jsonObject.get(ACCESS);
        JSONArray devicesJson = (JSONArray)jsonObject.get(DEVICES);
        ArrayList<Device> devices = new ArrayList<Device>(devicesJson.size());
        for (Object obj : devicesJson) {
            JSONObject deviceJson = (JSONObject)obj;
            devices.add(new Device(deviceJson));
        }
        PersonInvitation invitation = this.createPersonInvitationFrom((JSONObject)jsonObject.get(INVITATION));
        return new Person(testerId, emailStatus, invitationId, overallStatusModifiedAt, email, events, name, overallStatus, devices, invitation, access);
    }

    private PersonEvent createPersonEventFrom(JSONObject jsonObject) {
        String event = (String)jsonObject.get(EVENT);
        Date eventAt = ApiUtils.dateFromEpochSeconds((Long)jsonObject.get(EVENT_AT));
        String buildInstanceId = (String)jsonObject.get(BUILD_INSTANCE_ID);
        return new PersonEvent(event, eventAt, buildInstanceId);
    }

    private PersonInvitation createPersonInvitationFrom(JSONObject jsonObject) {
        long id = (Long)jsonObject.get(ID);
        String status = (String)jsonObject.get(STATUS);
        Date modifiedAt = ApiUtils.dateFromEpochSeconds((Long)jsonObject.get(MODIFIED_AT));
        return new PersonInvitation(id, status, modifiedAt);
    }
}

