/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android;

import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.PersistedSDK;
import com.crashlytics.tools.android.SDK;
import com.crashlytics.tools.utils.FileUtils;
import com.crashlytics.tools.utils.JarUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Manifest;

public class FileBasedSDK
implements PersistedSDK {
    private File _location;

    public FileBasedSDK(File location) {
        this._location = location;
    }

    @Override
    public boolean exists() {
        return this._location != null && this._location.exists();
    }

    public String toString() {
        if (this._location != null) {
            return String.format("SDK File:( %s )", this._location.getAbsolutePath());
        }
        return String.format("SDK File:( empty )", new Object[0]);
    }

    @Override
    public File getLocation() {
        return this._location;
    }

    @Override
    public String getVersion() {
        if (this._location == null) {
            return null;
        }
        Manifest manifest = JarUtils.getMaybeManifest(this._location);
        if (manifest == null) {
            return null;
        }
        return JarUtils.getVersion(manifest, "com/crashlytics/android/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceWith(SDK replacementSDK) {
        if (replacementSDK.exists()) {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(this._location, false);
                FileUtils.redirect(replacementSDK.getStream(), fos);
                fos.flush();
                this.closeIfNonNull(fos, "SDK Stream");
            }
            catch (Exception e) {
                try {
                    DeveloperTools.logE("An error occurred creating the default SDK at " + this._location, e);
                    this.closeIfNonNull(fos, "SDK Stream");
                }
                catch (Throwable throwable) {
                    this.closeIfNonNull(fos, "SDK Stream");
                    throw throwable;
                }
            }
        } else {
            DeveloperTools.logI("Crashlytics could not replace an SDK with an empty one.");
        }
    }

    private void closeIfNonNull(Closeable closable, String name) {
        if (closable != null) {
            try {
                closable.close();
            }
            catch (IOException e) {
                DeveloperTools.logE("Could not close " + name, e);
            }
        }
    }

    @Override
    public InputStream getStream() {
        try {
            return new FileInputStream(this._location);
        }
        catch (FileNotFoundException e) {
            DeveloperTools.logE("Crashlytics could not create a file stream for an sdk.", e);
            return null;
        }
    }
}

