/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard;

import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.onboard.Code;
import com.crashlytics.tools.android.onboard.CodeChange;
import com.crashlytics.tools.utils.GradleParser;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class AndroidGradleOnboarder {
    private static String MAVEN_REPOSITORY_LOCATION = "http://download.crashlytics.com/maven";
    private static String BUILDSCRIPT_REPOSITORY = String.format("maven { url '%s' }", MAVEN_REPOSITORY_LOCATION);
    private static String BUILDSCRIPT_DEPENDENCY = "classpath 'com.crashlytics.tools.gradle:crashlytics-gradle:1.+'";
    private static String APPLY_CRASHLYTICS = "apply plugin: 'crashlytics'";
    private static String ANDROID_REPOSITORY = BUILDSCRIPT_REPOSITORY;
    private static String ANDROID_GRADLE_PLUGIN = "com.crashlytics.android:crashlytics";
    private static String ANDROID_DEPENDENCY = String.format("compile '%s:1.+'", ANDROID_GRADLE_PLUGIN);
    private final GradleParser _parser;
    private final Code _code;

    public AndroidGradleOnboarder(GradleParser parser, Code code) {
        this._code = code;
        this._parser = parser;
    }

    public CodeChange getGradleCodeChanges() {
        CodeChange codeChanges = null;
        try {
            GradleParser.SearchResult applyCrashlyticsResult = this._parser.findTokenSet(GradleParser.CRASHLYTICS_PLUGIN_STRINGS);
            String codeAsString = this._code.getCode();
            if (applyCrashlyticsResult.wasFound() && codeAsString != null && codeAsString.contains(ANDROID_GRADLE_PLUGIN) && codeAsString.contains(MAVEN_REPOSITORY_LOCATION)) {
                return new CodeChange("build.gradle", this._code, Collections.<CodeChange.BlockChange>emptyList());
            }
            LinkedList<CodeChange.BlockChange> changesToCodeBlocks = new LinkedList<CodeChange.BlockChange>();
            GradleParser.SearchResult buildscriptResult = this._parser.findNestedClosures("buildscript");
            if (!buildscriptResult.wasFound()) {
                this.addInsertion(changesToCodeBlocks, 0, this.getTabs(0), "buildscript {\n", this.getTabs(1), "repositories {\n", this.getTabs(2), BUILDSCRIPT_REPOSITORY, "\n", this.getTabs(1), "}\n\n", this.getTabs(1), "dependencies {\n", this.getTabs(2), BUILDSCRIPT_DEPENDENCY, "\n", this.getTabs(1), "}\n", this.getTabs(0), "}\n");
            } else {
                GradleParser.SearchResult repositoryResult = this._parser.findNestedClosuresEnding("buildscript", "repositories");
                if (!repositoryResult.wasFound()) {
                    this.addInsertion(changesToCodeBlocks, buildscriptResult.getPosition(), "\n", this.getTabs(1), "repositories {\n", this.getTabs(2), BUILDSCRIPT_REPOSITORY, "\n", this.getTabs(1), "}\n");
                } else {
                    this.addInsertion(changesToCodeBlocks, repositoryResult.getPosition(), "\n", this.getTabs(2), BUILDSCRIPT_REPOSITORY, "\n");
                }
                GradleParser.SearchResult dependencyResult = this._parser.findNestedClosuresEnding("buildscript", "dependencies");
                if (!dependencyResult.wasFound()) {
                    this.addInsertion(changesToCodeBlocks, buildscriptResult.getPosition(), "\n", this.getTabs(1), "dependencies {\n", this.getTabs(2), BUILDSCRIPT_DEPENDENCY, "\n", this.getTabs(1), "}\n");
                } else {
                    this.addInsertion(changesToCodeBlocks, dependencyResult.getPosition(), "\n", this.getTabs(2), BUILDSCRIPT_DEPENDENCY, "\n");
                }
            }
            GradleParser.SearchResult applyAndroidResult = this._parser.findTokenSet(GradleParser.ANDROID_PLUGIN_STRINGS);
            if (!applyAndroidResult.wasFound()) {
                throw new LineNotFoundException("Failed to find apply plugin: 'android' line.");
            }
            this.addInsertion(changesToCodeBlocks, applyAndroidResult.getPosition(), "\n", APPLY_CRASHLYTICS);
            GradleParser.SearchResult repositoryResult = this._parser.findNestedClosuresEnding("repositories");
            if (!repositoryResult.wasFound()) {
                this.addInsertion(changesToCodeBlocks, applyAndroidResult.getPosition(), "\n", this.getTabs(0), "repositories {\n", this.getTabs(1), ANDROID_REPOSITORY, "\n", this.getTabs(0), "}\n");
            } else {
                this.addInsertion(changesToCodeBlocks, repositoryResult.getPosition(), "\n", this.getTabs(1), ANDROID_REPOSITORY, "\n");
            }
            GradleParser.SearchResult dependencyPosition = this._parser.findNestedClosuresEnding("dependencies");
            if (!dependencyPosition.wasFound()) {
                this.addInsertion(changesToCodeBlocks, applyAndroidResult.getPosition(), "\n", this.getTabs(0), "dependencies {\n", this.getTabs(1), ANDROID_DEPENDENCY, "\n", this.getTabs(0), "}\n");
            } else {
                this.addInsertion(changesToCodeBlocks, dependencyPosition.getPosition(), "\n", this.getTabs(1), ANDROID_DEPENDENCY, "\n");
            }
            codeChanges = new CodeChange("build.gradle", this._code, changesToCodeBlocks);
        }
        catch (IOException e) {
            DeveloperTools.logW("Crashlytics was unable to parse build.gradle", e);
        }
        catch (LineNotFoundException e) {
            DeveloperTools.logW("Crashlytics was unable to find a necessary line in the file.", e);
        }
        catch (Exception e) {
            DeveloperTools.logW("Crashlytics was unable to parse file.", e);
        }
        return codeChanges;
    }

    private void addInsertion(List<CodeChange.BlockChange> changesToCodeBlocks, int insertPosition, String ... text) {
        StringBuilder sb = new StringBuilder();
        for (String item : text) {
            sb.append(item);
        }
        CodeChange.Insertion insertion = new CodeChange.Insertion(insertPosition, sb.toString());
        DeveloperTools.logD(insertion.toString());
        changesToCodeBlocks.add(insertion);
    }

    private String getTabs(int numTabs) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < numTabs; ++i) {
            b.append("    ");
        }
        return b.toString();
    }

    private class LineNotFoundException
    extends Exception {
        public LineNotFoundException(String lineDescription) {
            super(lineDescription);
        }
    }
}

