/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard;

import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.onboard.AndroidGradleOnboarder;
import com.crashlytics.tools.android.onboard.CodeChange;
import com.crashlytics.tools.android.onboard.OnboardException;
import com.crashlytics.tools.android.onboard.StubCode;
import com.crashlytics.tools.android.project.AbstractManifestProvider;
import com.crashlytics.tools.android.project.AndroidProject;
import com.crashlytics.tools.android.project.ManifestData;
import com.crashlytics.tools.utils.FileUtils;
import com.crashlytics.tools.utils.GradleParser;
import com.crashlytics.tools.utils.GradleTokenizer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.LocatorImpl;

public abstract class AndroidOnboarder
extends AbstractManifestProvider {
    protected static final String MANIFEST_NAME = "AndroidManifest.xml";
    protected static final String JAVA_MAIN_ACTIVITY_NAME = "Start Activity";
    private static final String EXAMPLE_SRC_PATH = "examples/";
    public static final String SRC_ACTIVITY = "MainActivity.java.txt";
    public static final String SRC_MANIFEST = "AndroidManifest.xml.txt";
    public static final String BUILD_GRADLE_ACTIVITY = "build.gradle.txt";
    public static final String FILE_EXAMPLE_SRC_ACTIVITY = "examples/MainActivity.java.txt";
    public static final String FILE_EXAMPLE_SRC_MANIFEST = "examples/AndroidManifest.xml.txt";
    public static final String FILE_EXAMPLE_BUILD_GRADLE_ACTIVITY = "examples/build.gradle.txt";
    private final String _selectedApiKey;

    public AndroidOnboarder(String apiKey) {
        this._selectedApiKey = apiKey;
    }

    protected String getSelectedApiKey() {
        return this._selectedApiKey;
    }

    public List<CodeChange> getCodeChanges() throws OnboardException {
        CodeChange manifestChange = this.createManifestChange();
        CodeChange startCrashlytics = this.createStartCrashlyticsChange();
        return Arrays.asList(manifestChange, startCrashlytics);
    }

    public List<CodeChange> getCodeChangeDirections() throws OnboardException {
        return Arrays.asList(AndroidOnboarder.createDefaultManifestChanges(this._selectedApiKey), AndroidOnboarder.createDefaultJavaChanges());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CodeChange createDefaultManifestChanges(String apiKey) {
        String content = null;
        InputStream manifestStream = null;
        try {
            manifestStream = AndroidOnboarder.class.getClassLoader().getResourceAsStream(FILE_EXAMPLE_SRC_MANIFEST);
            content = FileUtils.streamToString(manifestStream);
        }
        catch (Exception e) {
            DeveloperTools.logE("Could not load example manifest: examples/AndroidManifest.xml.txt", e);
            CodeChange codeChange = CodeChange.createEmptyChange(MANIFEST_NAME, "");
            return codeChange;
        }
        finally {
            try {
                manifestStream.close();
            }
            catch (IOException e) {
                DeveloperTools.logW("Crashlytics could not close example manifest: examples/AndroidManifest.xml.txt", e);
            }
        }
        return AndroidOnboarder.createDefaultManifestChanges(apiKey, MANIFEST_NAME, content);
    }

    public static CodeChange createDefaultManifestChanges(String apiKey, String panelName, String manifestContents) {
        LinkedList<CodeChange.BlockChange> changes = new LinkedList<CodeChange.BlockChange>();
        String permissionSearchContent = "android:targetSdkVersion=\"15\" />";
        int permissionOffset = manifestContents.indexOf(permissionSearchContent) + permissionSearchContent.length() + 1;
        changes.add(new CodeChange.Insertion(permissionOffset, "  <uses-permission android:name=\"android.permission.INTERNET\"/>\n"));
        String apiSearchContent = "</activity>";
        int apiOffset = manifestContents.indexOf(apiSearchContent) + apiSearchContent.length() + 1;
        changes.add(new CodeChange.Insertion(apiOffset, "  " + String.format("<meta-data android:name=\"com.crashlytics.ApiKey\" android:value=\"%s\"/>", apiKey) + "\n\n"));
        return new CodeChange(panelName, new StubCode(manifestContents), changes);
    }

    public static CodeChange createDefaultJavaChanges() {
        String content = null;
        try {
            InputStream manifestStream = AndroidOnboarder.class.getClassLoader().getResourceAsStream(FILE_EXAMPLE_SRC_ACTIVITY);
            content = FileUtils.streamToString(manifestStream);
            manifestStream.close();
        }
        catch (IOException e) {
            DeveloperTools.logE("Could not load example source: examples/MainActivity.java.txt", e);
            return CodeChange.createEmptyChange(JAVA_MAIN_ACTIVITY_NAME, "");
        }
        return AndroidOnboarder.createDefaultJavaChanges(JAVA_MAIN_ACTIVITY_NAME, content);
    }

    public static CodeChange createDefaultJavaChanges(String panelName, String javaContents) {
        LinkedList<CodeChange.BlockChange> changes = new LinkedList<CodeChange.BlockChange>();
        String importSearchContent = "import android.app.Activity;";
        int importOffset = javaContents.indexOf(importSearchContent) + importSearchContent.length() + 1;
        changes.add(new CodeChange.Insertion(importOffset, "import com.crashlytics.android.Crashlytics;\n"));
        String startSearchContent = "super.onCreate(savedInstanceState);";
        int startOffset = javaContents.indexOf(startSearchContent) + startSearchContent.length() + 1;
        changes.add(new CodeChange.Insertion(startOffset, "    Crashlytics.start(this);\n\n"));
        return new CodeChange(panelName, new StubCode(javaContents), changes);
    }

    public static CodeChange createDefaultBuildGradleChanges() {
        String panelName = "build.gradle";
        String content = null;
        try {
            InputStream manifestStream = AndroidOnboarder.class.getClassLoader().getResourceAsStream(FILE_EXAMPLE_BUILD_GRADLE_ACTIVITY);
            content = FileUtils.streamToString(manifestStream);
            manifestStream.close();
        }
        catch (IOException e) {
            DeveloperTools.logE("Could not load example source: examples/MainActivity.java.txt", e);
            return CodeChange.createEmptyChange(panelName, "");
        }
        return AndroidOnboarder.createDefaultBuildGradleChanges(panelName, content);
    }

    public static CodeChange createDefaultBuildGradleChanges(String panelName, String gradleContents) {
        StubCode exampleCode = new StubCode(gradleContents);
        AndroidGradleOnboarder onboarder = new AndroidGradleOnboarder(new GradleParser(new GradleTokenizer(gradleContents)), exampleCode);
        return onboarder.getGradleCodeChanges();
    }

    protected abstract CodeChange createManifestChange() throws OnboardException;

    protected abstract CodeChange createStartCrashlyticsChange() throws OnboardException;

    protected static String getStartClassName(ManifestData data) {
        String startClass = data.getMainActivity();
        if (startClass == null) {
            startClass = data.getApplicationClass();
        }
        return startClass;
    }

    public String getLineSeparator(File source) throws IOException {
        return AndroidOnboarder.getLineSeparator(FileUtils.fileToString(source));
    }

    protected static String getLineSeparator(String contents) {
        int n = contents.indexOf(10);
        int r = contents.indexOf(13);
        if (n < 0) {
            if (r < 0) {
                return System.getProperty("line.separator");
            }
            return "\r";
        }
        if (r >= 0 && n == r + 1) {
            return "\r\n";
        }
        return "\n";
    }

    public List<CodeChange.BlockChange> getBlockChanges() throws OnboardException {
        return this.getBlockChanges(true);
    }

    public List<CodeChange.BlockChange> getBlockChanges(boolean onboarding) throws OnboardException {
        boolean usesInternet = false;
        String maybeApi = null;
        String manifestApiKey = null;
        LinkedList<CodeChange.BlockChange> changes = new LinkedList<CodeChange.BlockChange>();
        InputStream fileContentsStream = null;
        try {
            boolean apiNeedsUpdating;
            AndroidProject androidProject = this.getAndroidProject();
            ManifestData manifestData = androidProject.getManifestData();
            usesInternet = onboarding && manifestData.usesPermission("android.permission.INTERNET");
            maybeApi = androidProject.getApiKey();
            manifestApiKey = manifestData.getApiKey();
            boolean bl = apiNeedsUpdating = !onboarding || maybeApi == null || !maybeApi.equals(this._selectedApiKey);
            if (usesInternet && !apiNeedsUpdating) {
                List<CodeChange.BlockChange> list = Collections.emptyList();
                return list;
            }
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader xmlReader = factory.createXMLStreamReader(this.getManifestStream());
            String fileContents = this.getManifestString();
            fileContentsStream = this.getManifestStream();
            fileContentsStream.toString();
            String lineSep = AndroidOnboarder.getLineSeparator(fileContents);
            this.logLineSep(lineSep);
            String applicationIndent = AndroidOnboarder.getIndent(xmlReader, lineSep, "application");
            ElementOffsetFinder appOffset = AndroidOnboarder.getElementOffset(fileContentsStream, "application");
            changes = new LinkedList();
            if (!usesInternet) {
                Locator permissionsLocator = appOffset.getStartOffsetLocator();
                fileContentsStream.reset();
                int permissionsOffset = FileUtils.characterOffset(fileContentsStream, permissionsLocator.getLineNumber() - 1, permissionsLocator.getColumnNumber() - 1);
                changes.add(new CodeChange.Insertion(permissionsOffset, lineSep + lineSep + applicationIndent + "<uses-permission android:name=\"android.permission.INTERNET\"/>"));
            }
            if (apiNeedsUpdating) {
                if (manifestApiKey != null) {
                    HashMap<String, String> attributes = new HashMap<String, String>();
                    attributes.put("android:name", "com.crashlytics.ApiKey");
                    fileContentsStream.reset();
                    ElementOffsetFinder apiKeyOffset = this.getElementOffset(fileContentsStream, "meta-data", attributes);
                    Locator locator = apiKeyOffset.getStartOffsetLocator();
                    int pos = FileUtils.characterOffset(fileContentsStream, locator.getLineNumber(), locator.getColumnNumber());
                    if (pos == -1) {
                        throw new RuntimeException("Unexpected: API Key was present in XML, failed");
                    }
                    int startDelete = fileContents.indexOf(manifestApiKey, pos);
                    int endDelete = manifestApiKey.length() + startDelete;
                    changes.add(new CodeChange.Deletion(startDelete, endDelete));
                    changes.add(new CodeChange.Insertion(endDelete, this._selectedApiKey));
                } else {
                    fileContentsStream.reset();
                    String metadataElementStr = lineSep + this.createMetadataElement(applicationIndent);
                    Locator metadataLocator = appOffset.getEndOffsetLocator();
                    int metadataOffset = FileUtils.characterOffset(fileContentsStream, metadataLocator.getLineNumber() - 1, metadataLocator.getColumnNumber() - 1);
                    changes.add(new CodeChange.Insertion(metadataOffset, metadataElementStr));
                }
            }
            DeveloperTools.logD("Proposed Changes:\n" + changes);
        }
        catch (ManifestData.ManifestIOException e) {
            throw new OnboardException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new OnboardException("Crashlytics could not read the manifest. ", e);
        }
        catch (SAXException e) {
            throw new OnboardException("Crashlytics could not parse the manifest.", e);
        }
        catch (ParserConfigurationException e) {
            throw new OnboardException("Crashlytics could not configure the parser.", e);
        }
        catch (XMLStreamException e) {
            throw new OnboardException("Crashlytics could not parse the manifest xml.", e);
        }
        catch (Exception e) {
            throw new OnboardException("Crashlytics could not get changes for manifest.", e);
        }
        finally {
            if (fileContentsStream != null) {
                try {
                    fileContentsStream.close();
                }
                catch (IOException e) {
                    throw new OnboardException("Crashlytics could not close open manifest stream. ", e);
                }
            }
        }
        return changes;
    }

    private void logLineSep(String lineSep) {
        if (lineSep.equals("\r")) {
            DeveloperTools.logD("Crashlytics identified line separator: r (Mac 9 and below)");
        } else if (lineSep.equals("\r\n")) {
            DeveloperTools.logD("Crashlytics identified line separator: rn (Windows)");
        } else if (lineSep.equals("\n\r")) {
            DeveloperTools.logD("Crashlytics identified line separator: nr (Unexpected)");
        } else if (lineSep.equals("\n")) {
            DeveloperTools.logD("Crashlytics identified line separator: n (Unix)");
        } else {
            DeveloperTools.logD("Crashlytics identified line separator: [" + lineSep + "] (Unknown)");
        }
    }

    protected static String getIndent(XMLStreamReader xmlReader, String lineSep, String xmlNode) throws XMLStreamException {
        String applicationIndent = null;
        while (xmlReader.hasNext()) {
            xmlReader.next();
            if (xmlReader.isStartElement() && xmlReader.getLocalName().equals(xmlNode)) break;
            applicationIndent = xmlReader.isWhiteSpace() ? xmlReader.getText() : null;
        }
        if (applicationIndent == null) {
            applicationIndent = " ";
        } else {
            int lastLineBreak = applicationIndent.lastIndexOf(lineSep);
            if (lastLineBreak >= 0) {
                applicationIndent = applicationIndent.substring(lastLineBreak + 1);
            }
        }
        return applicationIndent;
    }

    private String createMetadataElement(String indent) {
        return indent + indent + String.format("<meta-data android:name=\"com.crashlytics.ApiKey\" android:value=\"%s\"/>", this._selectedApiKey);
    }

    protected static ElementOffsetFinder getElementOffset(InputStream xmlStream, String elementTag) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        ElementOffsetFinder handler = new ElementOffsetFinder(elementTag);
        parser.parse(xmlStream, (DefaultHandler)handler);
        return handler;
    }

    private ElementOffsetFinder getElementOffset(InputStream xmlStream, String elementTag, Map<String, String> attributes) throws SAXException, IOException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        ElementOffsetFinder handler = new ElementOffsetFinder(elementTag, attributes);
        parser.parse(xmlStream, (DefaultHandler)handler);
        return handler;
    }

    protected static class ElementOffsetFinder
    extends DefaultHandler {
        private Locator _startOffset = null;
        private boolean _foundStart = false;
        private Locator _endOffset = null;
        private boolean _foundEnd = false;
        private Locator _locator;
        private final String _elementQName;
        private Map<String, String> _attributeMatchTemplate;

        public ElementOffsetFinder(String elementQName, Map<String, String> attributeMatchTemplate) {
            this._elementQName = elementQName;
            this._attributeMatchTemplate = attributeMatchTemplate;
        }

        public ElementOffsetFinder(String elementQName) {
            this._elementQName = elementQName;
            this._attributeMatchTemplate = Collections.emptyMap();
        }

        public Locator getEndOffsetLocator() {
            return this._endOffset;
        }

        public Locator getStartOffsetLocator() {
            return this._startOffset;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            super.setDocumentLocator(locator);
            this._locator = locator;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            if (!this._foundStart) {
                if (qName.equals(this._elementQName)) {
                    this._foundStart = true;
                    for (Map.Entry<String, String> attribute : this._attributeMatchTemplate.entrySet()) {
                        String value;
                        int index = attributes.getIndex(attribute.getKey());
                        if (index <= -1 || (value = attribute.getValue()) != null && value.equals(attributes.getValue(index))) continue;
                        this._foundStart = false;
                    }
                } else {
                    this._startOffset = new LocatorImpl(this._locator);
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            if (this._foundStart && !this._foundEnd) {
                if (qName.equals(this._elementQName)) {
                    this._foundEnd = true;
                } else {
                    this._endOffset = new LocatorImpl(this._locator);
                }
            }
        }
    }
}

