/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard;

import com.crashlytics.tools.android.onboard.AndroidOnboarder;
import com.crashlytics.tools.android.onboard.CodeChange;
import com.crashlytics.tools.android.onboard.FileCode;
import com.crashlytics.tools.android.onboard.OnboardException;
import com.crashlytics.tools.android.project.AndroidProject;
import com.crashlytics.tools.android.project.ManifestData;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class FileAndroidOnboarder
extends AndroidOnboarder {
    private AndroidProject _project;

    public FileAndroidOnboarder(String apiKey, AndroidProject project) {
        super(apiKey);
        this._project = project;
    }

    @Override
    protected CodeChange createManifestChange() throws OnboardException {
        try {
            FileCode fileCode = new FileCode(this.getManifestFile());
            List<CodeChange.BlockChange> changes = this.getBlockChanges();
            return new CodeChange(this.getManifestFile().getName(), fileCode, changes);
        }
        catch (ManifestData.ManifestIOException e) {
            throw new OnboardException(e.getMessage(), e);
        }
    }

    @Override
    protected CodeChange createStartCrashlyticsChange() throws OnboardException {
        throw new UnsupportedOperationException("Crashlytics cannot onboard activities via the command line.");
    }

    @Override
    public String getManifestString() throws ManifestData.ManifestIOException {
        try {
            return FileUtils.readFileToString(this._project.getManifestFile());
        }
        catch (IOException e) {
            throw new ManifestData.ManifestIOException("Crashlytics could not process manifest file. ", e);
        }
    }

    @Override
    protected AndroidProject getAndroidProject() throws IOException {
        return this._project;
    }
}

